/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.number;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.Nullable;

public class ArgumentNumber<T extends Number>
extends Argument<T> {
    public static final int NOT_NUMBER_ERROR = 1;
    public static final int TOO_LOW_ERROR = 2;
    public static final int TOO_HIGH_ERROR = 3;
    protected boolean hasMin;
    protected boolean hasMax;
    protected T min;
    protected T max;
    protected final ArgumentParserType parserName;
    protected final BiFunction<String, Integer, T> radixParser;
    protected final Function<String, T> parser;
    protected final NetworkBuffer.Type<T> networkType;
    protected final Comparator<T> comparator;

    ArgumentNumber(String id, ArgumentParserType parserName, Function<String, T> parser, BiFunction<String, Integer, T> radixParser, NetworkBuffer.Type<T> networkType, Comparator<T> comparator) {
        super(id);
        this.parserName = parserName;
        this.radixParser = radixParser;
        this.parser = parser;
        this.networkType = networkType;
        this.comparator = comparator;
    }

    @Override
    public T parse(CommandSender sender, String input) throws ArgumentSyntaxException {
        try {
            int radix = this.getRadix(input);
            Number value = radix == 10 ? (Number)((Number)this.parser.apply(this.parseValue(input))) : (Number)((Number)this.radixParser.apply(this.parseValue(input), radix));
            if (this.hasMin && this.comparator.compare(value, (Number)this.min) < 0) {
                throw new ArgumentSyntaxException("Input is lower than the minimum allowed value", input, 2);
            }
            if (this.hasMax && this.comparator.compare(value, (Number)this.max) > 0) {
                throw new ArgumentSyntaxException("Input is higher than the maximum allowed value", input, 3);
            }
            return (T)value;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new ArgumentSyntaxException("Input is not a number, or it's invalid for the given type", input, 1);
        }
    }

    @Override
    public ArgumentParserType parser() {
        return this.parserName;
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return NetworkBuffer.makeArray(buffer -> {
            buffer.write(NetworkBuffer.BYTE, this.getNumberProperties());
            if (this.hasMin()) {
                this.networkType.write((NetworkBuffer)buffer, this.getMin());
            }
            if (this.hasMax()) {
                this.networkType.write((NetworkBuffer)buffer, this.getMax());
            }
        });
    }

    public ArgumentNumber<T> min(T value) {
        this.min = value;
        this.hasMin = true;
        return this;
    }

    public ArgumentNumber<T> max(T value) {
        this.max = value;
        this.hasMax = true;
        return this;
    }

    public ArgumentNumber<T> between(T min, T max) {
        this.min = min;
        this.max = max;
        this.hasMin = true;
        this.hasMax = true;
        return this;
    }

    public byte getNumberProperties() {
        byte result = 0;
        if (this.hasMin()) {
            result = (byte)(result | 1);
        }
        if (this.hasMax()) {
            result = (byte)(result | 2);
        }
        return result;
    }

    public boolean hasMin() {
        return this.hasMin;
    }

    public T getMin() {
        return this.min;
    }

    public boolean hasMax() {
        return this.hasMax;
    }

    public T getMax() {
        return this.max;
    }

    protected String parseValue(String value) {
        if (value.startsWith("0b")) {
            value = value.replaceFirst(Pattern.quote("0b"), "");
        } else if (value.startsWith("0x")) {
            value = value.replaceFirst(Pattern.quote("0x"), "");
        } else if (value.toLowerCase().contains("e")) {
            value = this.removeScientificNotation(value);
        }
        return value;
    }

    protected int getRadix(String value) {
        if (value.startsWith("0b")) {
            return 2;
        }
        if (value.startsWith("0x")) {
            return 16;
        }
        return 10;
    }

    @Nullable
    protected String removeScientificNotation(String value) {
        try {
            return new BigDecimal(value).toPlainString();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

