/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMapImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public sealed interface DataComponentMap
extends DataComponent.Holder
permits DataComponentMapImpl {
    public static final DataComponentMap EMPTY = new DataComponentMapImpl(Int2ObjectMaps.emptyMap());

    public static Builder builder() {
        return new DataComponentMapImpl.BuilderImpl(new Int2ObjectArrayMap<Object>());
    }

    public static PatchBuilder patchBuilder() {
        return new DataComponentMapImpl.PatchBuilderImpl(new Int2ObjectArrayMap<Object>());
    }

    @ApiStatus.Internal
    public static NetworkBuffer.Type<DataComponentMap> networkType(IntFunction<DataComponent<?>> idToType) {
        return new DataComponentMapImpl.NetworkTypeImpl(idToType, false, true);
    }

    @ApiStatus.Internal
    public static Codec<DataComponentMap> codec(IntFunction<DataComponent<?>> idToType, Function<String, DataComponent<?>> nameToType) {
        return new DataComponentMapImpl.CodecImpl(idToType, nameToType, false);
    }

    @ApiStatus.Internal
    public static NetworkBuffer.Type<DataComponentMap> patchNetworkType(IntFunction<DataComponent<?>> idToType, boolean trusted) {
        return new DataComponentMapImpl.NetworkTypeImpl(idToType, true, trusted);
    }

    @ApiStatus.Internal
    public static Codec<DataComponentMap> patchCodec(IntFunction<DataComponent<?>> idToType, Function<String, DataComponent<?>> nameToType) {
        return new DataComponentMapImpl.CodecImpl(idToType, nameToType, true);
    }

    public static DataComponentMap diff(DataComponentMap prototype, DataComponentMap patch) {
        DataComponentMapImpl patchImpl = (DataComponentMapImpl)patch;
        if (patchImpl.components().isEmpty()) {
            return EMPTY;
        }
        DataComponentMapImpl protoImpl = (DataComponentMapImpl)prototype;
        Int2ObjectArrayMap<@Nullable Object> diff = new Int2ObjectArrayMap<Object>(patchImpl.components());
        ObjectIterator iter2 = diff.int2ObjectEntrySet().fastIterator();
        while (iter2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter2.next();
            Object protoComp = protoImpl.components().get(entry.getIntKey());
            if (entry.getValue() == null) {
                if (protoImpl.components().containsKey(entry.getIntKey())) continue;
                iter2.remove();
                continue;
            }
            if (protoComp == null || !protoComp.equals(entry.getValue())) continue;
            iter2.remove();
        }
        return new DataComponentMapImpl(diff);
    }

    public boolean isEmpty();

    public boolean has(DataComponentMap var1, DataComponent<?> var2);

    @Nullable
    public <T> T get(DataComponentMap var1, DataComponent<T> var2);

    public <T> DataComponentMap set(DataComponent<T> var1, T var2);

    default public DataComponentMap set(DataComponent<Unit> component) {
        return this.set(component, Unit.INSTANCE);
    }

    public DataComponentMap remove(DataComponent<?> var1);

    public Collection<DataComponent.Value> entrySet();

    public Builder toBuilder();

    public PatchBuilder toPatchBuilder();

    public static sealed interface PatchBuilder
    extends DataComponent.Holder
    permits DataComponentMapImpl.PatchBuilderImpl {
        public <T> PatchBuilder set(DataComponent<T> var1, T var2);

        default public PatchBuilder set(DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        public PatchBuilder remove(DataComponent<?> var1);

        public DataComponentMap build();
    }

    public static sealed interface Builder
    extends DataComponent.Holder
    permits DataComponentMapImpl.BuilderImpl {
        public <T> Builder set(DataComponent<T> var1, T var2);

        default public Builder set(DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        public DataComponentMap build();
    }
}

