/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minestom.server.coordinate.AreaImpl;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.Point;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public sealed interface Area
extends Iterable<BlockVec> {
    default public Area offset(int x, int y, int z) {
        Area area = this;
        Objects.requireNonNull(area);
        Area area2 = area;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Single.class, Line.class, Cuboid.class, Sphere.class}, (Area)area2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Single single = (Single)area2;
                yield Area.single(single.point().add(x, y, z));
            }
            case 1 -> {
                Line line = (Line)area2;
                yield Area.line(line.start().add(x, y, z), line.end().add(x, y, z));
            }
            case 2 -> {
                Cuboid cuboid = (Cuboid)area2;
                yield Area.cuboid(cuboid.min().add(x, y, z), cuboid.max().add(x, y, z));
            }
            case 3 -> {
                Sphere sphere = (Sphere)area2;
                yield Area.sphere(sphere.center().add(x, y, z), sphere.radius());
            }
        };
    }

    default public Area offset(Point offset) {
        return this.offset(offset.blockX(), offset.blockY(), offset.blockZ());
    }

    default public Cuboid bound() {
        Area area = this;
        Objects.requireNonNull(area);
        Area area2 = area;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Single.class, Line.class, Cuboid.class, Sphere.class}, (Area)area2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Single single = (Single)area2;
                yield Area.cuboid(single.point(), single.point());
            }
            case 1 -> {
                Line line = (Line)area2;
                BlockVec start = line.start();
                BlockVec end = line.end();
                yield Area.cuboid(start.min(end), start.max(end));
            }
            case 2 -> {
                Cuboid cuboid;
                yield cuboid = (Cuboid)area2;
            }
            case 3 -> {
                Sphere sphere = (Sphere)area2;
                BlockVec center = sphere.center();
                int radius = sphere.radius();
                yield Area.cuboid(center.sub(radius, radius, radius), center.add(radius, radius, radius));
            }
        };
    }

    public List<Cuboid> split();

    public static Single single(Point point) {
        return new AreaImpl.Single(point.asBlockVec());
    }

    public static Single single(int x, int y, int z) {
        return Area.single(new BlockVec(x, y, z));
    }

    public static Line line(Point start, Point end) {
        return new AreaImpl.Line(start.asBlockVec(), end.asBlockVec());
    }

    public static Cuboid cuboid(Point min, Point max) {
        return new AreaImpl.Cuboid(min.asBlockVec(), max.asBlockVec());
    }

    public static Cuboid cube(Point center, int size) {
        return Area.cuboid(center.sub((double)size / 2.0), center.add((double)size / 2.0));
    }

    public static Cuboid box(Point center, Point size) {
        Point half = size.div(2.0);
        return Area.cuboid(center.sub(half), center.add(half));
    }

    public static Cuboid section(int sectionX, int sectionY, int sectionZ) {
        BlockVec section = BlockVec.SECTION.mul(sectionX, sectionY, sectionZ);
        return Area.cuboid(section, BlockVec.SECTION.add(section).sub(1));
    }

    public static Sphere sphere(Point center, int radius) {
        return new AreaImpl.Sphere(center.asBlockVec(), radius);
    }

    public static sealed interface Single
    extends Area
    permits AreaImpl.Single {
        public BlockVec point();
    }

    public static sealed interface Line
    extends Area
    permits AreaImpl.Line {
        public BlockVec start();

        public BlockVec end();
    }

    public static sealed interface Cuboid
    extends Area
    permits AreaImpl.Cuboid {
        public BlockVec min();

        public BlockVec max();
    }

    public static sealed interface Sphere
    extends Area
    permits AreaImpl.Sphere {
        public BlockVec center();

        public int radius();
    }
}

