/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.minestom.server.coordinate.Area;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.CoordConversion;

final class AreaImpl {
    AreaImpl() {
    }

    record Sphere(BlockVec center, int radius) implements Area.Sphere
    {
        public Sphere {
            Objects.requireNonNull(center, "Center cannot be null");
            if (radius < 0) {
                throw new IllegalArgumentException("Radius must be non-negative");
            }
        }

        @Override
        public Iterator<BlockVec> iterator() {
            final int minX = this.center.blockX() - this.radius;
            final int minY = this.center.blockY() - this.radius;
            final int minZ = this.center.blockZ() - this.radius;
            final int maxX = this.center.blockX() + this.radius;
            final int maxY = this.center.blockY() + this.radius;
            final int maxZ = this.center.blockZ() + this.radius;
            final double radiusSquared = this.radius * this.radius;
            return new Iterator<BlockVec>(this){
                private int x;
                private int y;
                private int z;
                private boolean hasNextValue;
                private BlockVec nextVec;
                final /* synthetic */ Sphere this$0;
                {
                    Sphere sphere = this$0;
                    Objects.requireNonNull(sphere);
                    this.this$0 = sphere;
                    this.x = minX;
                    this.y = minY;
                    this.z = minZ;
                    this.hasNextValue = true;
                    this.nextVec = this.findNext();
                }

                private BlockVec findNext() {
                    while (this.z <= maxZ) {
                        while (this.y <= maxY) {
                            while (this.x <= maxX) {
                                double dz;
                                double dy;
                                double dx = this.x - this.this$0.center.blockX();
                                double distanceSquared = dx * dx + (dy = (double)(this.y - this.this$0.center.blockY())) * dy + (dz = (double)(this.z - this.this$0.center.blockZ())) * dz;
                                if (distanceSquared <= radiusSquared) {
                                    BlockVec result = new BlockVec(this.x, this.y, this.z);
                                    ++this.x;
                                    return result;
                                }
                                ++this.x;
                            }
                            this.x = minX;
                            ++this.y;
                        }
                        this.y = minY;
                        ++this.z;
                    }
                    this.hasNextValue = false;
                    return new BlockVec(0, 0, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.hasNextValue;
                }

                @Override
                public BlockVec next() {
                    if (!this.hasNextValue) {
                        throw new NoSuchElementException();
                    }
                    BlockVec result = this.nextVec;
                    this.nextVec = this.findNext();
                    return result;
                }
            };
        }

        @Override
        public List<Area.Cuboid> split() {
            int sectionSize = BlockVec.SECTION.blockX();
            int minSecX = Math.floorDiv(this.center.blockX() - this.radius, sectionSize);
            int maxSecX = Math.floorDiv(this.center.blockX() + this.radius, sectionSize);
            int minSecY = Math.floorDiv(this.center.blockY() - this.radius, sectionSize);
            int maxSecY = Math.floorDiv(this.center.blockY() + this.radius, sectionSize);
            int minSecZ = Math.floorDiv(this.center.blockZ() - this.radius, sectionSize);
            int maxSecZ = Math.floorDiv(this.center.blockZ() + this.radius, sectionSize);
            ArrayList<Area.Cuboid> result = new ArrayList<Area.Cuboid>();
            double radiusSquared = this.radius * this.radius;
            for (int sx = minSecX; sx <= maxSecX; ++sx) {
                for (int sy = minSecY; sy <= maxSecY; ++sy) {
                    for (int sz = minSecZ; sz <= maxSecZ; ++sz) {
                        double dz;
                        double dy;
                        double dx;
                        int z;
                        int y;
                        int x;
                        int sectionMinX = sx * sectionSize;
                        int sectionMinY = sy * sectionSize;
                        int sectionMinZ = sz * sectionSize;
                        int sectionMaxX = sectionMinX + sectionSize - 1;
                        int sectionMaxY = sectionMinY + sectionSize - 1;
                        int sectionMaxZ = sectionMinZ + sectionSize - 1;
                        boolean fullSection = true;
                        for (x = sectionMinX; x <= sectionMaxX && fullSection; ++x) {
                            for (y = sectionMinY; y <= sectionMaxY && fullSection; ++y) {
                                for (z = sectionMinZ; z <= sectionMaxZ && fullSection; ++z) {
                                    dx = x - this.center.blockX();
                                    if (!(dx * dx + (dy = (double)(y - this.center.blockY())) * dy + (dz = (double)(z - this.center.blockZ())) * dz > radiusSquared)) continue;
                                    fullSection = false;
                                }
                            }
                        }
                        if (fullSection) {
                            result.add(Area.cuboid(new BlockVec(sectionMinX, sectionMinY, sectionMinZ), new BlockVec(sectionMaxX, sectionMaxY, sectionMaxZ)));
                            continue;
                        }
                        for (x = sectionMinX; x <= sectionMaxX; ++x) {
                            for (y = sectionMinY; y <= sectionMaxY; ++y) {
                                for (z = sectionMinZ; z <= sectionMaxZ; ++z) {
                                    dx = x - this.center.blockX();
                                    if (!(dx * dx + (dy = (double)(y - this.center.blockY())) * dy + (dz = (double)(z - this.center.blockZ())) * dz <= radiusSquared)) continue;
                                    BlockVec block = new BlockVec(x, y, z);
                                    result.add(Area.cuboid(block, block));
                                }
                            }
                        }
                    }
                }
            }
            return result;
        }
    }

    record Cuboid(BlockVec min, BlockVec max) implements Area.Cuboid
    {
        public Cuboid {
            Objects.requireNonNull(min, "min cannot be null");
            Objects.requireNonNull(max, "max cannot be null");
            BlockVec origMin = min;
            BlockVec origMax = max;
            min = origMin.min(origMax);
            max = origMin.max(origMax);
        }

        @Override
        public Iterator<BlockVec> iterator() {
            final int minX = this.min.blockX();
            final int minY = this.min.blockY();
            final int minZ = this.min.blockZ();
            final int maxX = this.max.blockX();
            final int maxY = this.max.blockY();
            final int maxZ = this.max.blockZ();
            return new Iterator<BlockVec>(this){
                private int x;
                private int y;
                private int z;
                private boolean hasNext;
                {
                    Objects.requireNonNull(this$0);
                    this.x = minX;
                    this.y = minY;
                    this.z = minZ;
                    this.hasNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public BlockVec next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    BlockVec vec = new BlockVec(this.x, this.y, this.z);
                    if (this.x == maxX && this.y == maxY && this.z == maxZ) {
                        this.hasNext = false;
                    } else if (this.x < maxX) {
                        ++this.x;
                    } else if (this.y < maxY) {
                        this.x = minX;
                        ++this.y;
                    } else if (this.z < maxZ) {
                        this.x = minX;
                        this.y = minY;
                        ++this.z;
                    }
                    return vec;
                }
            };
        }

        @Override
        public List<Area.Cuboid> split() {
            int sectionSize = BlockVec.SECTION.blockX();
            int minSecX = Math.floorDiv(this.min.blockX(), sectionSize);
            int minSecY = Math.floorDiv(this.min.blockY(), sectionSize);
            int minSecZ = Math.floorDiv(this.min.blockZ(), sectionSize);
            int maxSecX = Math.floorDiv(this.max.blockX(), sectionSize);
            int maxSecY = Math.floorDiv(this.max.blockY(), sectionSize);
            int maxSecZ = Math.floorDiv(this.max.blockZ(), sectionSize);
            ArrayList<Area.Cuboid> result = new ArrayList<Area.Cuboid>();
            for (int sx = minSecX; sx <= maxSecX; ++sx) {
                for (int sy = minSecY; sy <= maxSecY; ++sy) {
                    for (int sz = minSecZ; sz <= maxSecZ; ++sz) {
                        int sectionMinX = sx * sectionSize;
                        int sectionMinY = sy * sectionSize;
                        int sectionMinZ = sz * sectionSize;
                        int sectionMaxX = sectionMinX + sectionSize - 1;
                        int sectionMaxY = sectionMinY + sectionSize - 1;
                        int sectionMaxZ = sectionMinZ + sectionSize - 1;
                        int intersectMinX = Math.max(this.min.blockX(), sectionMinX);
                        int intersectMinY = Math.max(this.min.blockY(), sectionMinY);
                        int intersectMinZ = Math.max(this.min.blockZ(), sectionMinZ);
                        int intersectMaxX = Math.min(this.max.blockX(), sectionMaxX);
                        int intersectMaxY = Math.min(this.max.blockY(), sectionMaxY);
                        int intersectMaxZ = Math.min(this.max.blockZ(), sectionMaxZ);
                        if (intersectMinX > intersectMaxX || intersectMinY > intersectMaxY || intersectMinZ > intersectMaxZ) continue;
                        result.add(Area.cuboid(new BlockVec(intersectMinX, intersectMinY, intersectMinZ), new BlockVec(intersectMaxX, intersectMaxY, intersectMaxZ)));
                    }
                }
            }
            return result;
        }
    }

    record Line(BlockVec start, BlockVec end) implements Area.Line
    {
        public Line {
            Objects.requireNonNull(start, "Start point cannot be null");
            Objects.requireNonNull(end, "End point cannot be null");
        }

        @Override
        public Iterator<BlockVec> iterator() {
            if (this.start.samePoint(this.end)) {
                return List.of(this.start).iterator();
            }
            return new Iterator<BlockVec>(this){
                private final int x1;
                private final int y1;
                private final int z1;
                private final int x2;
                private final int y2;
                private final int z2;
                private int x;
                private int y;
                private int z;
                private boolean done;
                private final int dx;
                private final int dy;
                private final int dz;
                private final int sx;
                private final int sy;
                private final int sz;
                private int err1;
                private int err2;
                final /* synthetic */ Line this$0;
                {
                    Line line = this$0;
                    Objects.requireNonNull(line);
                    this.this$0 = line;
                    this.x1 = this.this$0.start.blockX();
                    this.y1 = this.this$0.start.blockY();
                    this.z1 = this.this$0.start.blockZ();
                    this.x2 = this.this$0.end.blockX();
                    this.y2 = this.this$0.end.blockY();
                    this.z2 = this.this$0.end.blockZ();
                    this.x = this.x1;
                    this.y = this.y1;
                    this.z = this.z1;
                    this.done = false;
                    this.dx = Math.abs(this.x2 - this.x1);
                    this.dy = Math.abs(this.y2 - this.y1);
                    this.dz = Math.abs(this.z2 - this.z1);
                    this.sx = this.x1 < this.x2 ? 1 : -1;
                    this.sy = this.y1 < this.y2 ? 1 : -1;
                    int n = this.sz = this.z1 < this.z2 ? 1 : -1;
                    if (this.dx >= this.dy && this.dx >= this.dz) {
                        this.err1 = this.dx / 2;
                        this.err2 = this.dx / 2;
                    } else if (this.dy >= this.dx && this.dy >= this.dz) {
                        this.err1 = this.dy / 2;
                        this.err2 = this.dy / 2;
                    } else {
                        this.err1 = this.dz / 2;
                        this.err2 = this.dz / 2;
                    }
                }

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public BlockVec next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    BlockVec result = new BlockVec(this.x, this.y, this.z);
                    if (this.x == this.x2 && this.y == this.y2 && this.z == this.z2) {
                        this.done = true;
                        return result;
                    }
                    if (this.dx >= this.dy && this.dx >= this.dz) {
                        this.x += this.sx;
                        this.err1 -= this.dy;
                        this.err2 -= this.dz;
                        if (this.err1 < 0) {
                            this.y += this.sy;
                            this.err1 += this.dx;
                        }
                        if (this.err2 < 0) {
                            this.z += this.sz;
                            this.err2 += this.dx;
                        }
                    } else if (this.dy >= this.dx && this.dy >= this.dz) {
                        this.y += this.sy;
                        this.err1 -= this.dx;
                        this.err2 -= this.dz;
                        if (this.err1 < 0) {
                            this.x += this.sx;
                            this.err1 += this.dy;
                        }
                        if (this.err2 < 0) {
                            this.z += this.sz;
                            this.err2 += this.dy;
                        }
                    } else {
                        this.z += this.sz;
                        this.err1 -= this.dx;
                        this.err2 -= this.dy;
                        if (this.err1 < 0) {
                            this.x += this.sx;
                            this.err1 += this.dz;
                        }
                        if (this.err2 < 0) {
                            this.y += this.sy;
                            this.err2 += this.dz;
                        }
                    }
                    return result;
                }
            };
        }

        @Override
        public List<Area.Cuboid> split() {
            HashSet<BlockVec> lineBlocks = new HashSet<BlockVec>();
            for (BlockVec block : this) {
                lineBlocks.add(block);
            }
            int sectionSize = BlockVec.SECTION.blockX();
            HashMap<Long, Set> sectionGroups = new HashMap<Long, Set>();
            for (BlockVec block : lineBlocks) {
                int sectionX = Math.floorDiv(block.blockX(), sectionSize);
                int sectionY = Math.floorDiv(block.blockY(), sectionSize);
                int sectionZ = Math.floorDiv(block.blockZ(), sectionSize);
                long sectionKey = CoordConversion.sectionIndex(sectionX, sectionY, sectionZ);
                sectionGroups.computeIfAbsent(sectionKey, k -> new HashSet()).add(block);
            }
            ArrayList<Area.Cuboid> result = new ArrayList<Area.Cuboid>();
            for (Set blocks : sectionGroups.values()) {
                for (BlockVec block : blocks) {
                    result.add(Area.cuboid(block, block));
                }
            }
            return result;
        }
    }

    record Single(BlockVec point) implements Area.Single
    {
        public Single {
            Objects.requireNonNull(point, "Point cannot be null");
        }

        @Override
        public Iterator<BlockVec> iterator() {
            return new Iterator<BlockVec>(this){
                private boolean hasNext;
                final /* synthetic */ Single this$0;
                {
                    Single single = this$0;
                    Objects.requireNonNull(single);
                    this.this$0 = single;
                    this.hasNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public BlockVec next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                    return this.this$0.point;
                }
            };
        }

        @Override
        public List<Area.Cuboid> split() {
            return List.of(new Cuboid(this.point, this.point));
        }
    }
}

