/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.function.DoubleUnaryOperator;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.Contract;

public record BlockVec(int blockX, int blockY, int blockZ) implements Point
{
    public static final BlockVec ZERO = new BlockVec(0);
    public static final BlockVec ONE = new BlockVec(1);
    public static final BlockVec SECTION = new BlockVec(16);

    public BlockVec(double x, double y, double z) {
        this(CoordConversion.globalToBlock(x), CoordConversion.globalToBlock(y), CoordConversion.globalToBlock(z));
    }

    public BlockVec(Point point) {
        this(point.blockX(), point.blockY(), point.blockZ());
    }

    public BlockVec(int value) {
        this(value, value, value);
    }

    public BlockVec(double value) {
        this(value, value, value);
    }

    @Override
    public double x() {
        return this.blockX;
    }

    @Override
    public double y() {
        return this.blockY;
    }

    @Override
    public double z() {
        return this.blockZ;
    }

    @Override
    public Point withX(DoubleUnaryOperator operator) {
        return new Vec(operator.applyAsDouble(this.blockX), this.blockY, this.blockZ);
    }

    @Override
    public Point withX(double x) {
        return new Vec(x, this.blockY, this.blockZ);
    }

    @Contract(pure=true)
    public BlockVec withBlockX(int x) {
        return new BlockVec(x, this.blockY, this.blockZ);
    }

    @Override
    public Point withY(DoubleUnaryOperator operator) {
        return new Vec(this.blockX, operator.applyAsDouble(this.blockY), this.blockZ);
    }

    @Override
    public Point withY(double y) {
        return new Vec(this.blockX, y, this.blockZ);
    }

    @Contract(pure=true)
    public BlockVec withBlockY(int y) {
        return new BlockVec(this.blockX, y, this.blockZ);
    }

    @Override
    public Point withZ(DoubleUnaryOperator operator) {
        return new Vec(this.blockX, this.blockY, operator.applyAsDouble(this.blockZ));
    }

    @Override
    public Point withZ(double z) {
        return new Vec(this.blockX, this.blockY, z);
    }

    @Contract(pure=true)
    public BlockVec withBlockZ(int z) {
        return new BlockVec(this.blockX, this.blockY, z);
    }

    @Override
    public Point add(double x, double y, double z) {
        return new Vec((double)this.blockX + x, (double)this.blockY + y, (double)this.blockZ + z);
    }

    @Contract(pure=true)
    public BlockVec add(int x, int y, int z) {
        return new BlockVec(this.blockX + x, this.blockY + y, this.blockZ + z);
    }

    @Override
    public Point add(Point point) {
        return new Vec((double)this.blockX + point.x(), (double)this.blockY + point.y(), (double)this.blockZ + point.z());
    }

    @Contract(pure=true)
    public BlockVec add(BlockVec blockVec) {
        return new BlockVec(this.blockX + blockVec.blockX, this.blockY + blockVec.blockY, this.blockZ + blockVec.blockZ);
    }

    @Override
    public Point add(double value) {
        return this.add(value, value, value);
    }

    @Contract(pure=true)
    public BlockVec add(int value) {
        return new BlockVec(this.blockX + value, this.blockY + value, this.blockZ + value);
    }

    @Override
    public Point sub(double x, double y, double z) {
        return new Vec((double)this.blockX - x, (double)this.blockY - y, (double)this.blockZ - z);
    }

    @Contract(pure=true)
    public BlockVec sub(int x, int y, int z) {
        return new BlockVec(this.blockX - x, this.blockY - y, this.blockZ - z);
    }

    @Override
    public Point sub(Point point) {
        return this.sub(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public BlockVec sub(BlockVec blockVec) {
        return new BlockVec(this.blockX - blockVec.blockX, this.blockY - blockVec.blockY, this.blockZ - blockVec.blockZ);
    }

    @Override
    public Point sub(double value) {
        return this.sub(value, value, value);
    }

    @Contract(pure=true)
    public BlockVec sub(int value) {
        return new BlockVec(this.blockX - value, this.blockY - value, this.blockZ - value);
    }

    @Override
    public Point mul(double x, double y, double z) {
        return new Vec((double)this.blockX * x, (double)this.blockY * y, (double)this.blockZ * z);
    }

    @Contract(pure=true)
    public BlockVec mul(int x, int y, int z) {
        return new BlockVec(this.blockX * x, this.blockY * y, this.blockZ * z);
    }

    @Override
    public Point mul(Point point) {
        return this.mul(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public BlockVec mul(BlockVec blockVec) {
        return new BlockVec(this.blockX * blockVec.blockX, this.blockY * blockVec.blockY, this.blockZ * blockVec.blockZ);
    }

    @Override
    public Point mul(double value) {
        return this.mul(value, value, value);
    }

    @Contract(pure=true)
    public BlockVec mul(int value) {
        return this.mul(value, value, value);
    }

    @Override
    public Point div(double x, double y, double z) {
        return new Vec((double)this.blockX / x, (double)this.blockY / y, (double)this.blockZ / z);
    }

    @Contract(pure=true)
    public BlockVec div(int x, int y, int z) {
        return new BlockVec(this.blockX / x, this.blockY / y, this.blockZ / z);
    }

    @Override
    public Point div(Point point) {
        return this.div(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public BlockVec div(BlockVec blockVec) {
        return new BlockVec(this.blockX / blockVec.blockX, this.blockY / blockVec.blockY, this.blockZ / blockVec.blockZ);
    }

    @Override
    public Point div(double value) {
        return this.div(value, value, value);
    }

    @Contract(pure=true)
    public BlockVec div(int value) {
        return this.div(value, value, value);
    }

    @Override
    @Contract(pure=true)
    public BlockVec relative(BlockFace face) {
        Direction direction = face.toDirection();
        return this.add(direction.normalX(), direction.normalY(), direction.normalZ());
    }

    @Contract(pure=true)
    public BlockVec neg() {
        return new BlockVec(-this.blockX, -this.blockY, -this.blockZ);
    }

    @Contract(pure=true)
    public BlockVec abs() {
        return new BlockVec(Math.abs(this.blockX), Math.abs(this.blockY), Math.abs(this.blockZ));
    }

    @Contract(pure=true)
    public Point min(Point point) {
        return new Vec(Math.min((double)this.blockX, point.x()), Math.min((double)this.blockY, point.y()), Math.min((double)this.blockZ, point.z()));
    }

    @Contract(pure=true)
    public BlockVec min(BlockVec point) {
        return new BlockVec(Math.min(this.blockX, point.blockX()), Math.min(this.blockY, point.blockY()), Math.min(this.blockZ, point.blockZ()));
    }

    @Contract(pure=true)
    public BlockVec min(int x, int y, int z) {
        return new BlockVec(Math.min(this.blockX, x), Math.min(this.blockY, y), Math.min(this.blockZ, z));
    }

    @Contract(pure=true)
    public BlockVec min(int value) {
        return new BlockVec(Math.min(this.blockX, value), Math.min(this.blockY, value), Math.min(this.blockZ, value));
    }

    @Contract(pure=true)
    public Point max(Point point) {
        return new Vec(Math.max((double)this.blockX, point.x()), Math.max((double)this.blockY, point.y()), Math.max((double)this.blockZ, point.z()));
    }

    @Contract(pure=true)
    public BlockVec max(BlockVec point) {
        return new BlockVec(Math.max(this.blockX, point.blockX()), Math.max(this.blockY, point.blockY()), Math.max(this.blockZ, point.blockZ()));
    }

    @Contract(pure=true)
    public BlockVec max(int x, int y, int z) {
        return new BlockVec(Math.max(this.blockX, x), Math.max(this.blockY, y), Math.max(this.blockZ, z));
    }

    @Contract(pure=true)
    public BlockVec max(int value) {
        return new BlockVec(Math.max(this.blockX, value), Math.max(this.blockY, value), Math.max(this.blockZ, value));
    }

    @Contract(pure=true)
    public boolean samePoint(int x, int y, int z) {
        return this.blockX == x && this.blockY == y && this.blockZ == z;
    }

    @Contract(pure=true)
    public boolean samePoint(BlockVec blockVec) {
        return this.blockX == blockVec.blockX && this.blockY == blockVec.blockY && this.blockZ == blockVec.blockZ;
    }
}

