/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;

public final class CoordConversion {
    public static final int REGION_SIZE = 512;
    public static final int SECTION_SIZE = 16;
    public static final int SECTION_BOUND = 15;
    public static final int SECTION_BLOCK_COUNT = 4096;
    private static final long PRIME_X = -7046029254386353131L;
    private static final long PRIME_Y = -434041037247419156L;
    private static final long PRIME_Z = -6510615555426900571L;
    private static final int ROT_X = 31;
    private static final int ROT_Y = 37;
    private static final int ROT_Z = 41;
    private static final long AVALANCHE_1 = -49064778989728563L;
    private static final long AVALANCHE_2 = -4265267296055464877L;
    private static final long INT_SEED = -3819410105021120785L;
    private static final long DOUBLE_SEED = -2401053089206453570L;

    public static int globalToBlock(double xyz) {
        return (int)Math.floor(xyz);
    }

    public static int globalToRegion(int xz) {
        return xz >> 9;
    }

    public static int globalToRegion(double xz) {
        int block = CoordConversion.globalToBlock(xz);
        return CoordConversion.globalToRegion(block);
    }

    public static int globalToChunk(int xz) {
        return CoordConversion.globalToSection(xz);
    }

    public static int globalToChunk(double xz) {
        int block = CoordConversion.globalToBlock(xz);
        return CoordConversion.globalToChunk(block);
    }

    public static int globalToSection(int xyz) {
        return xyz >> 4;
    }

    public static int globalToSectionRelative(int xyz) {
        return xyz & 0xF;
    }

    public static boolean sectionAligned(int xyz) {
        return CoordConversion.globalToSectionRelative(xyz) == 0;
    }

    public static boolean sectionAligned(int x, int y, int z) {
        return CoordConversion.sectionAligned(x) && CoordConversion.sectionAligned(y) && CoordConversion.sectionAligned(z);
    }

    public static boolean sectionAligned(Point point) {
        return CoordConversion.sectionAligned(point.blockX(), point.blockY(), point.blockZ());
    }

    public static boolean sectionAligned(Point p1, Point p2) {
        int minX = Math.min(p1.blockX(), p2.blockX());
        int minY = Math.min(p1.blockY(), p2.blockY());
        int minZ = Math.min(p1.blockZ(), p2.blockZ());
        int maxX = Math.max(p1.blockX(), p2.blockX());
        int maxY = Math.max(p1.blockY(), p2.blockY());
        int maxZ = Math.max(p1.blockZ(), p2.blockZ());
        return ((minX | minY | minZ) & 0xF) == 0 && ((maxX | maxY | maxZ) & 0xF) == 15;
    }

    public static int chunkToRegion(int chunkCoordinate) {
        return chunkCoordinate >> 5;
    }

    public static int chunkToRegionLocal(int chunkCoordinate) {
        return chunkCoordinate & 0x1F;
    }

    public static int floorSection(int coordinate) {
        return coordinate & 0xFFFFFFF0;
    }

    public static int ceilSection(int coordinate) {
        return coordinate + 15 & 0xFFFFFFF0;
    }

    public static long regionIndex(int regionX, int regionZ) {
        return (long)regionX << 32 | (long)regionZ & 0xFFFFFFFFL;
    }

    public static long regionIndex(Point point) {
        return CoordConversion.regionIndex(point.regionX(), point.regionZ());
    }

    public static int regionIndexGetX(long index) {
        return (int)(index >> 32);
    }

    public static int regionIndexGetZ(long index) {
        return (int)index;
    }

    public static long chunkIndex(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static long chunkIndex(Point point) {
        return CoordConversion.chunkIndex(point.chunkX(), point.chunkZ());
    }

    public static int chunkIndexGetX(long index) {
        return (int)(index >> 32);
    }

    public static int chunkIndexGetZ(long index) {
        return (int)index;
    }

    public static int chunkBlockIndex(int x, int y, int z) {
        x = CoordConversion.globalToSectionRelative(x);
        z = CoordConversion.globalToSectionRelative(z);
        return z << 28 | (y & Integer.MIN_VALUE) >>> 4 | (Math.abs(y) & 0x7FFFFF) << 4 | x;
    }

    public static int chunkBlockIndexGetX(int index) {
        return index & 0xF;
    }

    public static int chunkBlockIndexGetY(int index) {
        int y = (index & 0x7FFFFF0) >>> 4;
        if ((index & 0x8000000) != 0) {
            y = -y;
        }
        return y;
    }

    public static int chunkBlockIndexGetZ(int index) {
        return index >>> 28 & 0xF;
    }

    public static Point chunkBlockIndexGetGlobal(int index, int chunkX, int chunkZ) {
        int x = CoordConversion.chunkBlockIndexGetX(index) + 16 * chunkX;
        int y = CoordConversion.chunkBlockIndexGetY(index);
        int z = CoordConversion.chunkBlockIndexGetZ(index) + 16 * chunkZ;
        return new Vec(x, y, z);
    }

    public static Point chunkBlockRelativeGetGlobal(int sectionRelativeX, int y, int sectionRelativeZ, int chunkX, int chunkZ) {
        int x = sectionRelativeX + 16 * chunkX;
        int z = sectionRelativeZ + 16 * chunkZ;
        return new Vec(x, y, z);
    }

    public static long sectionIndex(int sectionX, int sectionY, int sectionZ) {
        long x = sectionX & 0x1FFFFF;
        long y = sectionY & 0x1FFFFF;
        long z = sectionZ & 0x1FFFFF;
        return x << 42 | y << 21 | z;
    }

    public static int sectionIndexGetX(long index) {
        int x = (int)(index >> 42) & 0x1FFFFF;
        if ((x & 0x100000) != 0) {
            x |= 0xFFE00000;
        }
        return x;
    }

    public static int sectionIndexGetY(long index) {
        int y = (int)(index >> 21) & 0x1FFFFF;
        if ((y & 0x100000) != 0) {
            y |= 0xFFE00000;
        }
        return y;
    }

    public static int sectionIndexGetZ(long index) {
        int z = (int)index & 0x1FFFFF;
        if ((z & 0x100000) != 0) {
            z |= 0xFFE00000;
        }
        return z;
    }

    public static long sectionIndexGlobal(int x, int y, int z) {
        int sectionX = CoordConversion.globalToChunk(x);
        int sectionY = CoordConversion.globalToChunk(y);
        int sectionZ = CoordConversion.globalToChunk(z);
        return CoordConversion.sectionIndex(sectionX, sectionY, sectionZ);
    }

    public static int sectionBlockIndex(int x, int y, int z) {
        return x << 8 | z << 4 | y;
    }

    public static int sectionBlockIndexGetX(int index) {
        return index >> 8 & 0xF;
    }

    public static int sectionBlockIndexGetY(int index) {
        return index & 0xF;
    }

    public static int sectionBlockIndexGetZ(int index) {
        return index >> 4 & 0xF;
    }

    public static long encodeSectionBlockChange(int sectionBlockIndex, long value) {
        long blockState = value << 12;
        return blockState | (long)sectionBlockIndex;
    }

    public static long encodeSectionBlockChange(int localX, int localY, int localZ, long value) {
        return CoordConversion.encodeSectionBlockChange(CoordConversion.sectionBlockIndex(localX, localY, localZ), value);
    }

    public static long hashBlockCoord(int x, int y, int z) {
        long h = -3819410105021120785L;
        h ^= Long.rotateLeft(Integer.toUnsignedLong(x) * -7046029254386353131L, 31);
        h ^= Long.rotateLeft(Integer.toUnsignedLong(y) * -434041037247419156L, 37);
        h ^= Long.rotateLeft(Integer.toUnsignedLong(z) * -6510615555426900571L, 41);
        h = Long.rotateLeft(h, 23) ^ h >>> 17;
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }

    public static long hashBlockCoord(Point point) {
        return CoordConversion.hashBlockCoord(point.blockX(), point.blockY(), point.blockZ());
    }

    public static long hashGlobalCoord(double x, double y, double z) {
        long h = -2401053089206453570L;
        long ix = Double.doubleToLongBits(x);
        long iy = Double.doubleToLongBits(y);
        long iz = Double.doubleToLongBits(z);
        long ex = ix >>> 52 & 0x7FFL;
        long ey = iy >>> 52 & 0x7FFL;
        long ez = iz >>> 52 & 0x7FFL;
        long mx = ix & 0xFFFFFFFFFFFFFL;
        long my = iy & 0xFFFFFFFFFFFFFL;
        long mz = iz & 0xFFFFFFFFFFFFFL;
        h ^= Long.rotateLeft(ix * -7046029254386353131L, 31);
        h ^= Long.rotateLeft(iy * -434041037247419156L, 37);
        h ^= Long.rotateLeft(iz * -6510615555426900571L, 41);
        h ^= Long.rotateLeft(ex << 32 | ey << 16 | ez, 19);
        h ^= Long.rotateLeft(mx ^ my ^ mz, 43);
        h = Long.rotateLeft(h, 29) ^ h >>> 13;
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }

    public static long hashGlobalCoord(Point point) {
        return CoordConversion.hashGlobalCoord(point.x(), point.y(), point.z());
    }

    public static String formatGlobalCoord(double x, double y, double z) {
        return "(%.3f, %.3f, %.3f)".formatted(x, y, z);
    }

    public static String formatGlobalCoord(Point point) {
        return CoordConversion.formatGlobalCoord(point.x(), point.y(), point.z());
    }

    public static String formatBlockCoord(int x, int y, int z) {
        return "(%d, %d, %d)".formatted(x, y, z);
    }

    public static String formatBlockCoord(Point point) {
        return CoordConversion.formatBlockCoord(point.blockX(), point.blockY(), point.blockZ());
    }
}

