/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;

public sealed interface Point
permits Vec, Pos, BlockVec {
    @Contract(pure=true)
    public double x();

    @Contract(pure=true)
    public double y();

    @Contract(pure=true)
    public double z();

    @Contract(pure=true)
    default public int blockX() {
        return CoordConversion.globalToBlock(this.x());
    }

    @Contract(pure=true)
    default public int blockY() {
        return CoordConversion.globalToBlock(this.y());
    }

    @Contract(pure=true)
    default public int blockZ() {
        return CoordConversion.globalToBlock(this.z());
    }

    @Contract(pure=true)
    default public int sectionX() {
        return CoordConversion.globalToSection(this.blockX());
    }

    @Contract(pure=true)
    default public int sectionY() {
        return CoordConversion.globalToSection(this.blockY());
    }

    @Contract(pure=true)
    default public int sectionZ() {
        return CoordConversion.globalToSection(this.blockZ());
    }

    @Contract(pure=true)
    default public int chunkX() {
        return this.sectionX();
    }

    @Contract(pure=true)
    default public int chunkZ() {
        return this.sectionZ();
    }

    @Contract(pure=true)
    default public int regionX() {
        return CoordConversion.globalToRegion(this.blockX());
    }

    @Contract(pure=true)
    default public int regionZ() {
        return CoordConversion.globalToRegion(this.blockZ());
    }

    @Deprecated
    @Contract(pure=true)
    default public int section() {
        return this.sectionY();
    }

    @Contract(pure=true)
    public Point withX(DoubleUnaryOperator var1);

    @Contract(pure=true)
    public Point withX(double var1);

    @Contract(pure=true)
    public Point withY(DoubleUnaryOperator var1);

    @Contract(pure=true)
    public Point withY(double var1);

    @Contract(pure=true)
    public Point withZ(DoubleUnaryOperator var1);

    @Contract(pure=true)
    public Point withZ(double var1);

    @Contract(pure=true)
    public Point add(double var1, double var3, double var5);

    @Contract(pure=true)
    public Point add(Point var1);

    @Contract(pure=true)
    public Point add(double var1);

    @Contract(pure=true)
    public Point sub(double var1, double var3, double var5);

    @Contract(pure=true)
    public Point sub(Point var1);

    @Contract(pure=true)
    public Point sub(double var1);

    @Contract(pure=true)
    public Point mul(double var1, double var3, double var5);

    @Contract(pure=true)
    public Point mul(Point var1);

    @Contract(pure=true)
    public Point mul(double var1);

    @Contract(pure=true)
    public Point div(double var1, double var3, double var5);

    @Contract(pure=true)
    public Point div(Point var1);

    @Contract(pure=true)
    public Point div(double var1);

    @Contract(pure=true)
    default public Point relative(BlockFace face) {
        Direction direction = face.toDirection();
        return this.add(direction.normalX(), direction.normalY(), direction.normalZ());
    }

    @Contract(pure=true)
    default public double distanceSquared(double x, double y, double z) {
        return MathUtils.square(this.x() - x) + MathUtils.square(this.y() - y) + MathUtils.square(this.z() - z);
    }

    @Contract(pure=true)
    default public double distanceSquared(Point point) {
        return this.distanceSquared(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    default public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Contract(pure=true)
    default public double distance(Point point) {
        return this.distance(point.x(), point.y(), point.z());
    }

    default public boolean samePoint(double x, double y, double z) {
        return x == this.x() && y == this.y() && z == this.z();
    }

    default public boolean samePoint(Point point) {
        return this.samePoint(point.x(), point.y(), point.z());
    }

    default public boolean samePoint(double x, double y, double z, double epsilon) {
        Check.argCondition(epsilon <= 0.0, "Epsilon must be greater than 0 but found {0}", epsilon);
        return Math.abs(x - this.x()) < epsilon && Math.abs(y - this.y()) < epsilon && Math.abs(z - this.z()) < epsilon;
    }

    default public boolean samePoint(Point point, double epsilon) {
        return this.samePoint(point.x(), point.y(), point.z(), epsilon);
    }

    default public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0 && this.z() == 0.0;
    }

    default public boolean sameChunk(Point point) {
        return this.chunkX() == point.chunkX() && this.chunkZ() == point.chunkZ();
    }

    default public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return this.blockX() == blockX && this.blockY() == blockY && this.blockZ() == blockZ;
    }

    default public boolean sameBlock(Point point) {
        return this.sameBlock(point.blockX(), point.blockY(), point.blockZ());
    }

    @Contract(pure=true)
    default public Pos asPos() {
        Point point = this;
        Objects.requireNonNull(point);
        Point point2 = point;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pos.class, Vec.class, BlockVec.class}, (Point)point2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Pos pos;
                yield pos = (Pos)point2;
            }
            case 1 -> {
                Vec vec = (Vec)point2;
                yield new Pos(vec.x(), vec.y(), vec.z());
            }
            case 2 -> {
                BlockVec blockVec = (BlockVec)point2;
                yield new Pos(blockVec.blockX(), (double)blockVec.blockY(), (double)blockVec.blockZ());
            }
        };
    }

    @Contract(pure=true)
    default public Vec asVec() {
        Point point = this;
        Objects.requireNonNull(point);
        Point point2 = point;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Vec.class, Pos.class, BlockVec.class}, (Point)point2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Vec vec;
                yield vec = (Vec)point2;
            }
            case 1 -> {
                Pos pos = (Pos)point2;
                yield new Vec(pos.x(), pos.y(), pos.z());
            }
            case 2 -> {
                BlockVec blockVec = (BlockVec)point2;
                yield new Vec(blockVec.blockX(), blockVec.blockY(), blockVec.blockZ());
            }
        };
    }

    @Contract(pure=true)
    default public BlockVec asBlockVec() {
        Point point = this;
        Objects.requireNonNull(point);
        Point point2 = point;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockVec.class, Pos.class, Vec.class}, (Point)point2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                BlockVec blockVec;
                yield blockVec = (BlockVec)point2;
            }
            case 1 -> {
                Pos pos = (Pos)point2;
                yield new BlockVec(pos.blockX(), pos.blockY(), pos.blockZ());
            }
            case 2 -> {
                Vec vec = (Vec)point2;
                yield new BlockVec(vec.blockX(), vec.blockY(), vec.blockZ());
            }
        };
    }
}

