/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.crypto;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.UnknownNullability;

public record MessageSignature(byte[] signature) {
    static final int SIGNATURE_BYTE_LENGTH = 256;
    public static final NetworkBuffer.Type<MessageSignature> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.RAW_BYTES, MessageSignature::signature, MessageSignature::new);

    public MessageSignature {
        if (signature.length != 256) {
            throw new IllegalArgumentException("Signature must be 256 bytes long");
        }
    }

    public record Packed(int id, @UnknownNullability MessageSignature fullSignature) {
        public static final NetworkBuffer.Type<Packed> SERIALIZER = new NetworkBuffer.Type<Packed>(){

            @Override
            public void write(NetworkBuffer buffer, Packed value) {
                buffer.write(NetworkBuffer.VAR_INT, value.id + 1);
                if (value.id == 0) {
                    buffer.write(MessageSignature.SERIALIZER, value.fullSignature);
                }
            }

            @Override
            public Packed read(NetworkBuffer buffer) {
                int id;
                return new Packed(id, (id = buffer.read(NetworkBuffer.VAR_INT) - 1) == -1 ? buffer.read(MessageSignature.SERIALIZER) : null);
            }
        };

        private Packed(Packed packed) {
            this(packed.id, packed.fullSignature);
        }
    }
}

