/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.dialog;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.dialog.DialogActionButton;
import net.minestom.server.dialog.DialogMetadata;
import net.minestom.server.dialog.RegistryKeyDialog;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.HolderSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public sealed interface Dialog
extends Holder.Direct<Dialog>,
DialogLike {
    public static final Registry<StructCodec<? extends Dialog>> REGISTRY = DynamicRegistry.fromMap(Key.key("dialog_type"), Map.entry(Key.key("notice"), Notice.CODEC), Map.entry(Key.key("server_links"), ServerLinks.CODEC), Map.entry(Key.key("dialog_list"), DialogList.CODEC), Map.entry(Key.key("multi_action"), MultiAction.CODEC), Map.entry(Key.key("confirmation"), Confirmation.CODEC));
    public static final Codec<Dialog> REGISTRY_CODEC = Codec.RegistryTaggedUnion(REGISTRY, Dialog::codec);
    public static final NetworkBuffer.Type<Dialog> REGISTRY_NETWORK_TYPE = NetworkBuffer.TypedNBT(REGISTRY_CODEC);
    public static final NetworkBuffer.Type<Holder<Dialog>> NETWORK_TYPE = Holder.networkType(Registries::dialog, REGISTRY_NETWORK_TYPE);
    public static final Codec<Holder<Dialog>> CODEC = Holder.codec(Registries::dialog, REGISTRY_CODEC);

    public static DialogLike forKey(RegistryKey<Dialog> key) {
        return new RegistryKeyDialog(key);
    }

    @ApiStatus.Internal
    public static DialogLike wrap(Holder<Dialog> dialog) {
        Holder<Dialog> holder = dialog;
        Objects.requireNonNull(holder);
        Holder<Dialog> holder2 = holder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dialog.class, RegistryKey.class}, holder2, n)) {
            case 0 -> {
                Dialog direct;
                yield direct = (Dialog)holder2;
            }
            case 1 -> {
                RegistryKey reference = (RegistryKey)holder2;
                yield new RegistryKeyDialog(reference);
            }
            default -> throw new IllegalArgumentException("Unsupported dialog type: " + dialog.getClass().getName());
        };
    }

    @ApiStatus.Internal
    public static Holder<Dialog> unwrap(DialogLike dialog) {
        DialogLike dialogLike = dialog;
        Objects.requireNonNull(dialogLike);
        DialogLike dialogLike2 = dialogLike;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dialog.class, RegistryKeyDialog.class}, (DialogLike)dialogLike2, n)) {
            case 0 -> {
                Dialog direct;
                yield direct = (Dialog)dialogLike2;
            }
            case 1 -> {
                RegistryKeyDialog reference = (RegistryKeyDialog)dialogLike2;
                yield reference.key();
            }
            default -> throw new IllegalArgumentException("Unsupported dialog type: " + dialog.getClass().getName());
        };
    }

    @ApiStatus.Internal
    public static DynamicRegistry<Dialog> createDefaultRegistry(Registries registries) {
        return DynamicRegistry.createForDialogWithSelfReferentialLoadingNightmare(Key.key("dialog"), REGISTRY_CODEC, RegistryData.Resource.DIALOGS, registries);
    }

    public DialogMetadata metadata();

    public StructCodec<? extends Dialog> codec();

    public record Notice(DialogMetadata metadata, DialogActionButton action) implements Dialog
    {
        public static final DialogActionButton DEFAULT_ACTION = new DialogActionButton(Component.translatable("gui.ok"), null, 150, null);
        public static final StructCodec<Notice> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, Notice::metadata, "action", DialogActionButton.CODEC.optional(DEFAULT_ACTION), Notice::action, Notice::new);

        @Override
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record ServerLinks(DialogMetadata metadata, @Nullable DialogActionButton exitAction, int columns, int buttonWidth) implements Dialog
    {
        public static final StructCodec<ServerLinks> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, ServerLinks::metadata, "exit_action", DialogActionButton.CODEC.optional(), ServerLinks::exitAction, "columns", Codec.INT.optional(2), ServerLinks::columns, "button_width", Codec.INT.optional(150), ServerLinks::buttonWidth, ServerLinks::new);

        @Override
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record DialogList(DialogMetadata metadata, HolderSet<Dialog> dialogs, @Nullable DialogActionButton exitAction, int columns, int buttonWidth) implements Dialog
    {
        public static final StructCodec<DialogList> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, DialogList::metadata, "dialogs", HolderSet.codec(Registries::dialog, Codec.ForwardRef(() -> REGISTRY_CODEC)), DialogList::dialogs, "exit_action", DialogActionButton.CODEC.optional(), DialogList::exitAction, "columns", Codec.INT.optional(2), DialogList::columns, "button_width", Codec.INT.optional(150), DialogList::buttonWidth, DialogList::new);

        @Override
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record MultiAction(DialogMetadata metadata, List<DialogActionButton> actions, @Nullable DialogActionButton exitAction, int columns) implements Dialog
    {
        public static final StructCodec<MultiAction> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, MultiAction::metadata, "actions", DialogActionButton.CODEC.list(), MultiAction::actions, "exit_action", DialogActionButton.CODEC.optional(), MultiAction::exitAction, "columns", Codec.INT.optional(2), MultiAction::columns, MultiAction::new);

        @Override
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record Confirmation(DialogMetadata metadata, DialogActionButton yesButton, DialogActionButton noButton) implements Dialog
    {
        public static final StructCodec<Confirmation> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, Confirmation::metadata, "yes", DialogActionButton.CODEC, Confirmation::yesButton, "no", DialogActionButton.CODEC, Confirmation::noButton, Confirmation::new);

        @Override
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }
}

