/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Comparator;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.thread.Acquirable;
import org.jetbrains.annotations.ApiStatus;

public class ExperienceOrb
extends Entity {
    private short experienceCount;
    private Player target;
    private long lastTargetUpdateTick;

    public ExperienceOrb(short experienceCount) {
        super(EntityType.EXPERIENCE_ORB);
        this.setBoundingBox(0.5, 0.5, 0.5);
        this.experienceCount = experienceCount;
    }

    @Override
    public void update(long time) {
        if (this.hasNoGravity()) {
            this.setVelocity(this.getVelocity().add(0.0, -0.3f, 0.0));
        }
        double d = 8.0;
        if (this.lastTargetUpdateTick < time - 20L + (long)(this.getEntityId() % 100)) {
            if (this.target == null || this.target.getPosition().distanceSquared(this.getPosition()) > 64.0) {
                this.target = this.getClosestPlayer(this, 8.0f);
            }
            this.lastTargetUpdateTick = time;
        }
        if (this.target != null && this.target.getGameMode() == GameMode.SPECTATOR) {
            this.target = null;
        }
        if (this.target != null) {
            Pos pos = this.getPosition();
            Pos targetPos = this.target.getPosition();
            Vec toTarget = new Vec(targetPos.x() - pos.x(), targetPos.y() + this.target.getEyeHeight() / 2.0 - pos.y(), targetPos.z() - pos.z());
            double e = toTarget.length();
            if (e < 8.0) {
                double f = 1.0 - e / 8.0;
                this.setVelocity(this.getVelocity().add(toTarget.normalize().mul(f * f * 0.1)));
            }
        }
        float g = 0.98f;
        if (this.onGround) {
            g = 0.58800006f;
        }
        this.setVelocity(this.getVelocity().mul(new Vec(g, 0.98f, g)));
        if (this.isOnGround()) {
            this.setVelocity(this.getVelocity().mul(new Vec(1.0, -0.9f, 1.0)));
        }
    }

    @Override
    public void spawn() {
    }

    public short getExperienceCount() {
        return this.experienceCount;
    }

    public void setExperienceCount(short experienceCount) {
        this.getViewers().forEach(this::removeViewer);
        this.experienceCount = experienceCount;
        this.getViewers().forEach(this::addViewer);
    }

    private Player getClosestPlayer(Entity entity, float maxDistance) {
        Player closest = entity.getInstance().getPlayers().stream().min(Comparator.comparingDouble(a -> a.getDistanceSquared(entity))).orElse(null);
        if (closest == null) {
            return null;
        }
        if (closest.getDistanceSquared(entity) > (double)(maxDistance * maxDistance)) {
            return null;
        }
        return closest;
    }

    @Override
    @ApiStatus.Experimental
    public Acquirable<? extends ExperienceOrb> acquirable() {
        return super.acquirable();
    }
}

