/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.metadata.item.ItemEntityMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityItemMergeEvent;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.item.ItemStack;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ItemEntity
extends Entity {
    private static Duration mergeDelay = Duration.of(10L, TimeUnit.SERVER_TICK);
    private long lastMergeCheck;
    private ItemStack itemStack;
    private boolean pickable = true;
    private boolean mergeable = true;
    private float mergeRange = 1.0f;
    private boolean previousOnGround = false;
    private long spawnTime;
    private long pickupDelay;

    public ItemEntity(ItemStack itemStack) {
        super(EntityType.ITEM);
        this.setItemStack(itemStack);
        this.setBoundingBox(0.25, 0.25, 0.25);
    }

    @Nullable
    public static Duration getMergeDelay() {
        return mergeDelay;
    }

    public static void setMergeDelay(@Nullable Duration delay) {
        mergeDelay = delay;
    }

    @Override
    public void update(long time) {
        if (this.isMergeable() && this.isPickable() && (mergeDelay == null || !Cooldown.hasCooldown(time, this.lastMergeCheck, mergeDelay))) {
            this.lastMergeCheck = time;
            this.instance.getEntityTracker().nearbyEntities(this.position, this.mergeRange, EntityTracker.Target.ITEMS, itemEntity -> {
                if (itemEntity == this) {
                    return;
                }
                if (!itemEntity.isPickable() || !itemEntity.isMergeable()) {
                    return;
                }
                ItemStack itemStackEntity = itemEntity.getItemStack();
                boolean canStack = this.itemStack.isSimilar(itemStackEntity);
                if (!canStack) {
                    return;
                }
                int totalAmount = this.itemStack.amount() + itemStackEntity.amount();
                if (!MathUtils.isBetween(totalAmount, 0, this.itemStack.maxStackSize())) {
                    return;
                }
                ItemStack result = this.itemStack.withAmount(totalAmount);
                EntityItemMergeEvent entityItemMergeEvent = new EntityItemMergeEvent(this, (ItemEntity)itemEntity, result);
                EventDispatcher.callCancellable(entityItemMergeEvent, () -> {
                    this.setItemStack(entityItemMergeEvent.getResult());
                    itemEntity.remove();
                });
            });
        }
    }

    @Override
    public void movementTick() {
        super.movementTick();
        if (!this.previousOnGround && this.onGround) {
            this.synchronizePosition();
            this.sendPacketToViewers(this.getVelocityPacket());
        }
        this.previousOnGround = this.onGround;
    }

    @Override
    public void spawn() {
        this.spawnTime = System.nanoTime();
    }

    @Override
    public ItemEntityMeta getEntityMeta() {
        return (ItemEntityMeta)super.getEntityMeta();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.getEntityMeta().setItem(itemStack);
    }

    public boolean isPickable() {
        return this.pickable && this.getTimeSinceSpawn() >= this.pickupDelay;
    }

    public void setPickable(boolean pickable) {
        this.pickable = pickable;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public float getMergeRange() {
        return this.mergeRange;
    }

    public void setMergeRange(float mergeRange) {
        this.mergeRange = mergeRange;
    }

    public long getPickupDelay() {
        return this.pickupDelay;
    }

    public void setPickupDelay(long delay, TemporalUnit temporalUnit) {
        this.setPickupDelay(Duration.of(delay, temporalUnit));
    }

    public void setPickupDelay(Duration delay) {
        this.pickupDelay = delay.toMillis();
    }

    @Deprecated(forRemoval=true)
    public long getSpawnTime() {
        return this.getTimeSinceSpawn();
    }

    public long getTimeSinceSpawn() {
        return java.util.concurrent.TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.spawnTime);
    }

    @Override
    @ApiStatus.Experimental
    public Acquirable<? extends ItemEntity> acquirable() {
        return super.acquirable();
    }
}

