/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.function.Function;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.EntityProjectile;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.pathfinding.Navigator;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import net.minestom.server.utils.validate.Check;

public class CombinedAttackGoal
extends GoalSelector {
    private final Cooldown cooldown = new Cooldown(Duration.of(5L, TimeUnit.SERVER_TICK));
    private final int meleeRangeSquared;
    private final Duration meleeDelay;
    private final int rangedRangeSquared;
    private final double rangedPower;
    private final double rangedSpread;
    private final Duration rangedDelay;
    private final int desirableRangeSquared;
    private final boolean comeClose;
    private Function<Entity, EntityProjectile> projectileGenerator;
    private long lastAttack;
    private boolean stop;
    private Entity cachedTarget;

    public CombinedAttackGoal(EntityCreature entityCreature, int meleeRange, int rangedRange, double rangedPower, double rangedSpread, int delay, TemporalUnit timeUnit, int desirableRange, boolean comeClose) {
        this(entityCreature, meleeRange, delay, timeUnit, rangedRange, rangedPower, rangedSpread, delay, timeUnit, desirableRange, comeClose);
    }

    public CombinedAttackGoal(EntityCreature entityCreature, int meleeRange, int rangedRange, double rangedPower, double rangedSpread, Duration delay, int desirableRange, boolean comeClose) {
        this(entityCreature, meleeRange, delay, rangedRange, rangedPower, rangedSpread, delay, desirableRange, comeClose);
    }

    public CombinedAttackGoal(EntityCreature entityCreature, int meleeRange, int meleeDelay, TemporalUnit meleeTimeUnit, int rangedRange, double rangedPower, double rangedSpread, int rangedDelay, TemporalUnit rangedTimeUnit, int desirableRange, boolean comeClose) {
        this(entityCreature, meleeRange, Duration.of(meleeDelay, meleeTimeUnit), rangedRange, rangedPower, rangedSpread, Duration.of(rangedDelay, rangedTimeUnit), desirableRange, comeClose);
    }

    public CombinedAttackGoal(EntityCreature entityCreature, int meleeRange, Duration meleeDelay, int rangedRange, double rangedPower, double rangedSpread, Duration rangedDelay, int desirableRange, boolean comeClose) {
        super(entityCreature);
        this.meleeRangeSquared = meleeRange * meleeRange;
        this.meleeDelay = meleeDelay;
        this.rangedRangeSquared = rangedRange * rangedRange;
        this.rangedPower = rangedPower;
        this.rangedSpread = rangedSpread;
        this.rangedDelay = rangedDelay;
        this.desirableRangeSquared = desirableRange * desirableRange;
        this.comeClose = comeClose;
        Check.argCondition(desirableRange > rangedRange, "Desirable range can not exceed ranged range!");
    }

    public Cooldown getCooldown() {
        return this.cooldown;
    }

    public void setProjectileGenerator(Function<Entity, EntityProjectile> projectileGenerator) {
        this.projectileGenerator = projectileGenerator;
    }

    @Override
    public boolean shouldStart() {
        this.cachedTarget = this.findTarget();
        return this.cachedTarget != null;
    }

    @Override
    public void start() {
        this.entityCreature.getNavigator().setPathTo(this.cachedTarget.getPosition());
    }

    @Override
    public void tick(long time) {
        Entity target;
        if (this.cachedTarget != null) {
            target = this.cachedTarget;
            this.cachedTarget = null;
        } else {
            target = this.findTarget();
        }
        if (target == null) {
            this.stop = true;
            return;
        }
        double distanceSquared = this.entityCreature.getDistanceSquared(target);
        boolean comeClose = false;
        if (distanceSquared <= (double)this.meleeRangeSquared) {
            if (!Cooldown.hasCooldown(time, this.lastAttack, this.meleeDelay)) {
                this.entityCreature.attack(target, true);
                this.lastAttack = time;
            }
        } else if (distanceSquared <= (double)this.rangedRangeSquared && !Cooldown.hasCooldown(time, this.lastAttack, this.rangedDelay)) {
            if (this.entityCreature.hasLineOfSight(target)) {
                Pos to = target.getPosition().add(0.0, target.getEyeHeight(), 0.0);
                Function<Entity, EntityProjectile> projectileGenerator = this.projectileGenerator;
                if (projectileGenerator == null) {
                    projectileGenerator = shooter -> new EntityProjectile((Entity)shooter, EntityType.ARROW);
                }
                EntityProjectile projectile = projectileGenerator.apply(this.entityCreature);
                projectile.setInstance(this.entityCreature.getInstance(), this.entityCreature.getPosition());
                projectile.shoot(to, this.rangedPower, this.rangedSpread);
                this.lastAttack = time;
            } else {
                comeClose = this.comeClose;
            }
        }
        Navigator navigator = this.entityCreature.getNavigator();
        Point pathPosition = navigator.getPathPosition();
        if (!comeClose && distanceSquared <= (double)this.desirableRangeSquared) {
            if (pathPosition != null) {
                navigator.setPathTo(null);
            }
            this.entityCreature.lookAt(target);
            return;
        }
        Pos targetPosition = target.getPosition();
        if ((pathPosition == null || !pathPosition.samePoint(targetPosition)) && this.cooldown.isReady(time)) {
            this.cooldown.refreshLastUpdate(time);
            navigator.setPathTo(targetPosition);
        }
    }

    @Override
    public boolean shouldEnd() {
        return this.stop;
    }

    @Override
    public void end() {
        this.entityCreature.getNavigator().setPathTo(null);
    }
}

