/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.target;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.TargetSelector;
import net.minestom.server.entity.damage.Damage;
import net.minestom.server.entity.damage.EntityDamage;

public class LastEntityDamagerTarget
extends TargetSelector {
    private final float range;

    public LastEntityDamagerTarget(EntityCreature entityCreature, float range) {
        super(entityCreature);
        this.range = range;
    }

    @Override
    public Entity findTarget() {
        Damage damage = this.entityCreature.getLastDamageSource();
        if (!(damage instanceof EntityDamage)) {
            return null;
        }
        EntityDamage entityDamage = (EntityDamage)damage;
        Entity entity = entityDamage.getSource();
        if (entity.isRemoved()) {
            return null;
        }
        return this.entityCreature.getDistanceSquared(entity) < (double)(this.range * this.range) ? entity : null;
    }
}

