/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.ChestedHorseMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.Nullable;

public class LlamaMeta
extends ChestedHorseMeta {
    public LlamaMeta(Entity entity, MetadataHolder metadata) {
        super(entity, metadata);
    }

    public int getStrength() {
        return this.metadata.get(MetadataDef.Llama.STRENGTH);
    }

    public void setStrength(int value) {
        this.metadata.set(MetadataDef.Llama.STRENGTH, value);
    }

    public int getCarpetColor() {
        return this.metadata.get(MetadataDef.Llama.CARPET_COLOR);
    }

    public void setCarpetColor(int value) {
        this.metadata.set(MetadataDef.Llama.CARPET_COLOR, value);
    }

    @Deprecated
    public Variant getVariant() {
        return Variant.VALUES[this.metadata.get(MetadataDef.Llama.VARIANT)];
    }

    @Deprecated
    public void setVariant(Variant value) {
        this.metadata.set(MetadataDef.Llama.VARIANT, value.ordinal());
    }

    @Override
    @Nullable
    protected <T> T get(DataComponent<T> component) {
        if (component == DataComponents.LLAMA_VARIANT) {
            return (T)((Object)this.getVariant());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(DataComponent<T> component, T value) {
        if (component == DataComponents.LLAMA_VARIANT) {
            this.setVariant((Variant)((Object)value));
        } else {
            super.set(component, value);
        }
    }

    public static enum Variant {
        CREAMY,
        WHITE,
        BROWN,
        GRAY;

        public static final NetworkBuffer.Type<Variant> NETWORK_TYPE;
        public static final Codec<Variant> CODEC;
        private static final Variant[] VALUES;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Variant.class);
            CODEC = Codec.Enum(Variant.class);
            VALUES = Variant.values();
        }
    }
}

