/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.PigVariantImpl;
import net.minestom.server.entity.metadata.animal.PigVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;

public sealed interface PigVariant
extends PigVariants
permits PigVariantImpl {
    public static final Codec<PigVariant> REGISTRY_CODEC = StructCodec.struct("model", Model.CODEC.optional(Model.NORMAL), PigVariant::model, "asset_id", Codec.KEY, PigVariant::assetId, PigVariantImpl::new);
    public static final NetworkBuffer.Type<RegistryKey<PigVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::pigVariant);
    public static final Codec<RegistryKey<PigVariant>> CODEC = RegistryKey.codec(Registries::pigVariant);

    @ApiStatus.Internal
    public static DynamicRegistry<PigVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("pig_variant"), REGISTRY_CODEC, RegistryData.Resource.PIG_VARIANTS);
    }

    public static PigVariant create(Model model, Key assetId) {
        return new PigVariantImpl(model, assetId);
    }

    public Model model();

    public Key assetId();

    public static enum Model {
        NORMAL,
        COLD;

        public static final Codec<Model> CODEC;

        static {
            CODEC = Codec.Enum(Model.class);
        }
    }
}

