/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import java.util.List;
import java.util.function.Supplier;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.PPath;
import net.minestom.server.entity.pathfinding.PathGenerator;
import net.minestom.server.entity.pathfinding.followers.GroundNodeFollower;
import net.minestom.server.entity.pathfinding.followers.NodeFollower;
import net.minestom.server.entity.pathfinding.generators.GroundNodeGenerator;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.network.packet.server.play.ParticlePacket;
import net.minestom.server.particle.Particle;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class Navigator {
    private Point goalPosition;
    private final Entity entity;
    private PPath computingPath;
    private PPath path;
    private double minimumDistance;
    NodeGenerator nodeGenerator = new GroundNodeGenerator();
    private NodeFollower nodeFollower;

    public Navigator(Entity entity) {
        this.entity = entity;
        this.nodeFollower = new GroundNodeFollower(entity);
    }

    public PPath.State getState() {
        if (this.path == null && this.computingPath == null) {
            return PPath.State.INVALID;
        }
        if (this.path == null) {
            return this.computingPath.getState();
        }
        return this.path.getState();
    }

    public synchronized boolean setPathTo(@Nullable Point point) {
        BoundingBox bb = this.entity.getBoundingBox();
        double centerToCorner = Math.sqrt(bb.width() * bb.width() + bb.depth() * bb.depth()) / 2.0;
        return this.setPathTo(point, centerToCorner, null);
    }

    public synchronized boolean setPathTo(@Nullable Point point, double minimumDistance, @Nullable Runnable onComplete) {
        return this.setPathTo(point, minimumDistance, 50.0, 20.0, onComplete);
    }

    public synchronized boolean setPathTo(@Nullable Point point, double minimumDistance, double maxDistance, double pathVariance, @Nullable Runnable onComplete) {
        Instance instance = this.entity.getInstance();
        if (point == null) {
            this.path = null;
            return false;
        }
        if (instance == null) {
            this.path = null;
            return false;
        }
        WorldBorder worldBorder = instance.getWorldBorder();
        if (!worldBorder.inBounds(point)) {
            return false;
        }
        Chunk chunk = instance.getChunkAt(point);
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        this.minimumDistance = minimumDistance;
        if (this.entity.getPosition().distance(point) < minimumDistance) {
            if (onComplete != null) {
                onComplete.run();
            }
            return false;
        }
        if (point.sameBlock(this.entity.getPosition())) {
            if (onComplete != null) {
                onComplete.run();
            }
            return false;
        }
        if (this.computingPath != null) {
            this.computingPath.setState(PPath.State.TERMINATING);
        }
        this.computingPath = PathGenerator.generate(instance, this.entity.getPosition(), point, minimumDistance, maxDistance, pathVariance, this.entity.getBoundingBox(), this.entity.isOnGround(), this.nodeGenerator, onComplete);
        this.goalPosition = point;
        return true;
    }

    @ApiStatus.Internal
    public synchronized void tick() {
        if (this.goalPosition == null) {
            return;
        }
        if (this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isDead()) {
            return;
        }
        if (this.computingPath != null && (this.computingPath.getState() == PPath.State.COMPUTED || this.computingPath.getState() == PPath.State.BEST_EFFORT)) {
            this.path = this.computingPath;
            this.computingPath = null;
        }
        if (this.path == null) {
            return;
        }
        if (this.path.getState() == PPath.State.COMPUTED || this.path.getState() == PPath.State.BEST_EFFORT) {
            this.path.setState(PPath.State.FOLLOWING);
            for (int i = 0; i < this.path.getNodes().size(); ++i) {
                if (!Navigator.isSameBlock(this.path.getNodes().get(i), this.entity.getPosition())) continue;
                this.path.getNodes().subList(0, i).clear();
                break;
            }
        }
        if (this.path.getState() != PPath.State.FOLLOWING) {
            return;
        }
        if (this.entity.getPosition().distance(this.goalPosition) < this.minimumDistance) {
            this.path.runComplete();
            this.path = null;
            return;
        }
        Point currentTarget = this.path.getCurrent();
        Point nextTarget = this.path.getNext();
        if (currentTarget == null || this.path.getCurrentType() == PNode.Type.REPATH || this.path.getCurrentType() == null) {
            if (this.computingPath != null && this.computingPath.getState() == PPath.State.CALCULATING) {
                return;
            }
            this.computingPath = PathGenerator.generate(this.entity.getInstance(), this.entity.getPosition(), this.goalPosition.asPos(), this.minimumDistance, this.path.maxDistance(), this.path.pathVariance(), this.entity.getBoundingBox(), this.entity.isOnGround(), this.nodeGenerator, null);
            return;
        }
        if (nextTarget == null) {
            this.path.setState(PPath.State.INVALID);
            return;
        }
        boolean nextIsRepath = nextTarget.sameBlock(Pos.ZERO);
        this.nodeFollower.moveTowards(currentTarget, this.nodeFollower.movementSpeed(), nextIsRepath ? currentTarget : nextTarget);
        if (this.nodeFollower.isAtPoint(currentTarget)) {
            this.path.next();
        } else if (this.path.getCurrentType() == PNode.Type.JUMP) {
            this.nodeFollower.jump(currentTarget, nextTarget);
        }
    }

    @Nullable
    public Point getGoalPosition() {
        return this.goalPosition;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void reset() {
        if (this.path != null) {
            this.path.setState(PPath.State.TERMINATING);
        }
        this.goalPosition = null;
        this.path = null;
        if (this.computingPath != null) {
            this.computingPath.setState(PPath.State.TERMINATING);
        }
        this.computingPath = null;
    }

    public boolean isComplete() {
        if (this.path == null) {
            return true;
        }
        return this.goalPosition == null || this.entity.getPosition().sameBlock(this.goalPosition);
    }

    public List<PNode> getNodes() {
        if (this.path == null && this.computingPath == null) {
            return null;
        }
        if (this.path == null) {
            return this.computingPath.getNodes();
        }
        return this.path.getNodes();
    }

    public Point getPathPosition() {
        return this.goalPosition;
    }

    public void setNodeFollower(Supplier<NodeFollower> nodeFollower) {
        this.nodeFollower = nodeFollower.get();
    }

    public void setNodeGenerator(Supplier<NodeGenerator> nodeGenerator) {
        this.nodeGenerator = nodeGenerator.get();
    }

    private void drawPath(PPath path) {
        if (path == null) {
            return;
        }
        for (PNode point : path.getNodes()) {
            ParticlePacket packet = new ParticlePacket(Particle.COMPOSTER, point.x(), point.y() + 0.5, point.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1);
            this.entity.sendPacketToViewers(packet);
        }
    }

    private static boolean isSameBlock(PNode pNode, Pos position) {
        return Math.floor(pNode.x()) == (double)position.blockX() && Math.floor(pNode.y()) == (double)position.blockY() && Math.floor(pNode.z()) == (double)position.blockZ();
    }
}

