/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.block.Block;

public class GroundNodeGenerator
implements NodeGenerator {
    private PNode tempNode = null;
    private final BoundingBox.PointIterator pointIterator = new BoundingBox.PointIterator();
    private static final int MAX_FALL_DISTANCE = 5;

    @Override
    public Collection<? extends PNode> getWalkable(Block.Getter getter, Set<PNode> visited, PNode current, Point goal, BoundingBox boundingBox) {
        ArrayList<PNode> nearby = new ArrayList<PNode>();
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, current);
        int stepSize = (int)Math.max(Math.floor(boundingBox.width() / 2.0), 1.0);
        if (stepSize < 1) {
            stepSize = 1;
        }
        for (int x = -stepSize; x <= stepSize; ++x) {
            for (int z = -stepSize; z <= stepSize; ++z) {
                double floorPointZ;
                double floorPointY;
                if (x == 0 && z == 0) continue;
                double cost = Math.sqrt(x * x + z * z) * 0.98;
                double floorPointX = (double)current.blockX() + 0.5 + (double)x;
                OptionalDouble optionalFloorPointY = this.gravitySnap(getter, floorPointX, floorPointY = (double)current.blockY(), floorPointZ = (double)current.blockZ() + 0.5 + (double)z, boundingBox, 5.0);
                if (optionalFloorPointY.isEmpty()) continue;
                floorPointY = optionalFloorPointY.getAsDouble();
                Vec floorPoint = new Vec(floorPointX, floorPointY, floorPointZ);
                PNode nodeWalk = this.createWalk(getter, floorPoint, boundingBox, cost, current, goal, visited);
                if (nodeWalk != null && !visited.contains(nodeWalk)) {
                    nearby.add(nodeWalk);
                }
                for (int i = 1; i <= 1; ++i) {
                    PNode nodeJump;
                    Point jumpPoint = new Vec((double)current.blockX() + 0.5 + (double)x, current.blockY() + i, (double)current.blockZ() + 0.5 + (double)z);
                    OptionalDouble jumpPointY = this.gravitySnap(getter, jumpPoint.x(), jumpPoint.y(), jumpPoint.z(), boundingBox, 5.0);
                    if (jumpPointY.isEmpty() || floorPoint.sameBlock(jumpPoint = jumpPoint.withY(jumpPointY.getAsDouble())) || (nodeJump = this.createJump(getter, jumpPoint, boundingBox, cost + 0.2, current, goal, visited)) == null || visited.contains(nodeJump)) continue;
                    nearby.add(nodeJump);
                }
            }
        }
        return nearby;
    }

    private PNode createWalk(Block.Getter getter, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (Math.abs(point.y() - start.y()) > 1.0E-6 && point.y() < start.y()) {
            if (start.y() - point.y() > 5.0) {
                return null;
            }
            if (!this.canMoveTowards(getter, new Vec(start.x(), start.y(), start.z()), point.withY(start.y()), boundingBox)) {
                return null;
            }
            n.setType(PNode.Type.FALL);
        } else if (!this.canMoveTowards(getter, new Vec(start.x(), start.y(), start.z()), point, boundingBox)) {
            return null;
        }
        return n;
    }

    private PNode createJump(Block.Getter getter, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        if (Math.abs(point.y() - start.y()) < 1.0E-6) {
            return null;
        }
        if (point.y() - start.y() > 2.0) {
            return null;
        }
        if (point.blockX() != start.blockX() && point.blockZ() != start.blockZ()) {
            return null;
        }
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (this.pointInvalid(getter, point, boundingBox)) {
            return null;
        }
        if (this.pointInvalid(getter, new Vec(start.x(), start.y() + 1.0, start.z()), boundingBox)) {
            return null;
        }
        n.setType(PNode.Type.JUMP);
        return n;
    }

    private PNode newNode(PNode current, double cost, Point point, Point goal) {
        this.tempNode.setG(current.g() + cost);
        this.tempNode.setH(this.heuristic(point, goal));
        this.tempNode.setPoint(point.x(), point.y(), point.z());
        PNode newNode = this.tempNode;
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, PNode.Type.WALK, current);
        return newNode;
    }

    @Override
    public boolean hasGravitySnap() {
        return true;
    }

    @Override
    public OptionalDouble gravitySnap(Block.Getter getter, double pointOrgX, double pointOrgY, double pointOrgZ, BoundingBox boundingBox, double maxFall) {
        double pointX = (double)((int)Math.floor(pointOrgX)) + 0.5;
        double pointY = (int)Math.floor(pointOrgY);
        double pointZ = (double)((int)Math.floor(pointOrgZ)) + 0.5;
        int axis = 1;
        while ((double)axis <= maxFall) {
            this.pointIterator.reset(boundingBox, pointX, pointY, pointZ, BoundingBox.AxisMask.Y, -axis);
            while (this.pointIterator.hasNext()) {
                BoundingBox.MutablePoint block = this.pointIterator.next();
                if (!getter.getBlock(block.blockX(), block.blockY(), block.blockZ(), Block.Getter.Condition.TYPE).isSolid()) continue;
                return OptionalDouble.of(block.blockY() + 1);
            }
            ++axis;
        }
        return OptionalDouble.empty();
    }
}

