/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.entity;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.event.trait.EntityEvent;
import net.minestom.server.utils.position.PositionUtils;

public class EntityTeleportEvent
implements EntityEvent {
    private final Entity entity;
    private final Pos teleportPosition;
    private final int relativeFlags;

    public EntityTeleportEvent(Entity entity, Pos teleportPosition, int relativeFlags) {
        this.entity = entity;
        this.teleportPosition = teleportPosition;
        this.relativeFlags = relativeFlags;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public Pos getNewPosition() {
        return PositionUtils.getPositionWithRelativeFlags(this.getEntity().getPosition(), this.getTeleportPosition(), this.relativeFlags);
    }

    public Pos getTeleportPosition() {
        return this.teleportPosition;
    }

    public int getRelativeFlags() {
        return this.relativeFlags;
    }
}

