/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.inventory;

import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.InventoryEvent;
import net.minestom.server.event.trait.PlayerInstanceEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.item.ItemStack;

public class InventoryPreClickEvent
implements InventoryEvent,
PlayerInstanceEvent,
CancellableEvent {
    private final AbstractInventory inventory;
    private final Player player;
    private Click click;
    private boolean cancelled;

    public InventoryPreClickEvent(AbstractInventory inventory, Player player, Click click) {
        this.inventory = inventory;
        this.player = player;
        this.click = click;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public Click getClick() {
        return this.click;
    }

    public void setClick(Click click) {
        this.click = click;
    }

    public int getSlot() {
        return this.click.slot();
    }

    public ItemStack getClickedItem() {
        int slot = this.getSlot();
        return slot == -999 ? this.player.getInventory().getCursorItem() : this.inventory.getItemStack(slot);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public AbstractInventory getInventory() {
        return this.inventory;
    }
}

