/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.event.trait.AsyncEvent;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.plugin.LoginPlugin;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;

public class AsyncPlayerPreLoginEvent
implements AsyncEvent {
    private final PlayerConnection connection;
    private GameProfile gameProfile;
    private final LoginPluginMessageProcessor pluginMessageProcessor;

    public AsyncPlayerPreLoginEvent(PlayerConnection connection, GameProfile gameProfile, LoginPluginMessageProcessor pluginMessageProcessor) {
        this.connection = connection;
        this.gameProfile = gameProfile;
        this.pluginMessageProcessor = pluginMessageProcessor;
    }

    public PlayerConnection getConnection() {
        return this.connection;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    public CompletableFuture<LoginPlugin.Response> sendPluginRequest(String channel, byte[] requestPayload) {
        return this.pluginMessageProcessor.request(channel, requestPayload);
    }

    @Deprecated
    public String getUsername() {
        return this.gameProfile.name();
    }

    @Deprecated
    public void setUsername(String username) {
        this.gameProfile = new GameProfile(this.gameProfile.uuid(), username, this.gameProfile.properties());
    }

    @Deprecated
    public UUID getPlayerUuid() {
        return this.gameProfile.uuid();
    }
}

