/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.PlayerInstanceEvent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;

public class PlayerChangeHeldSlotEvent
implements PlayerInstanceEvent,
CancellableEvent {
    private final Player player;
    private final byte oldSlot;
    private byte newSlot;
    private boolean cancelled;

    public PlayerChangeHeldSlotEvent(Player player, byte oldSlot, byte newSlot) {
        this.player = player;
        this.oldSlot = oldSlot;
        this.newSlot = newSlot;
    }

    @Deprecated(forRemoval=true)
    public byte getSlot() {
        return this.newSlot;
    }

    public byte getOldSlot() {
        return this.oldSlot;
    }

    public byte getNewSlot() {
        return this.newSlot;
    }

    @Deprecated(forRemoval=true)
    public void setSlot(byte slot) {
        Check.argCondition(!MathUtils.isBetween((int)slot, 0, 8), "The held slot needs to be between 0 and 8");
        this.newSlot = slot;
    }

    public void setNewSlot(byte slot) {
        Check.argCondition(!MathUtils.isBetween((int)slot, 0, 8), "The held slot needs to be between 0 and 8");
        this.newSlot = slot;
    }

    public ItemStack getItemInOldSlot() {
        return this.player.getInventory().getItemStack(this.oldSlot);
    }

    public ItemStack getItemInNewSlot() {
        return this.player.getInventory().getItemStack(this.newSlot);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }
}

