/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.response;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.query.response.QueryKey;
import net.minestom.server.network.NetworkBuffer;

public class FullQueryResponse {
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();
    private static final byte[] PADDING_10 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PADDING_11 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Map<String, String> kv = new HashMap<String, String>();
    private List<String> players;
    public static final NetworkBuffer.Type<FullQueryResponse> SERIALIZER = new NetworkBuffer.Type<FullQueryResponse>(){

        @Override
        public void write(NetworkBuffer buffer, FullQueryResponse value) {
            buffer.write(NetworkBuffer.RAW_BYTES, PADDING_11);
            for (Map.Entry<String, String> entry : value.kv.entrySet()) {
                buffer.write(NetworkBuffer.STRING_TERMINATED, entry.getKey());
                buffer.write(NetworkBuffer.STRING_TERMINATED, entry.getValue());
            }
            buffer.write(NetworkBuffer.STRING_TERMINATED, "");
            buffer.write(NetworkBuffer.RAW_BYTES, PADDING_10);
            for (String player : value.players) {
                buffer.write(NetworkBuffer.STRING_TERMINATED, player);
            }
            buffer.write(NetworkBuffer.STRING_TERMINATED, "");
        }

        @Override
        public FullQueryResponse read(NetworkBuffer buffer) {
            throw new UnsupportedOperationException("FullQueryResponse is write-only");
        }
    };

    public FullQueryResponse() {
        for (QueryKey key : QueryKey.VALUES) {
            this.kv.put(key.getKey(), key.getValue());
        }
        this.players = MinecraftServer.getConnectionManager().getOnlinePlayers().stream().map(player -> PLAIN.serialize(player.getName())).toList();
    }

    public void put(QueryKey key, String value) {
        this.put(key.getKey(), value);
    }

    public void put(String key, String value) {
        this.kv.put(key, value);
    }

    public Map<String, String> getKeyValuesMap() {
        return this.kv;
    }

    public void setKeyValuesMap(Map<String, String> map) {
        this.kv = Objects.requireNonNull(map, "map");
    }

    public void addPlayers(String ... players) {
        Collections.addAll(this.players, players);
    }

    public void addPlayers(Collection<String> players) {
        this.players.addAll(players);
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(List<String> players) {
        this.players = Objects.requireNonNull(players, "players");
    }

    public static String generatePluginsValue() {
        StringBuilder builder = new StringBuilder(MinecraftServer.getBrandName()).append(' ').append("1.21.10");
        return builder.toString();
    }
}

