/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.Tickable;
import net.minestom.server.Viewable;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.heightmap.Heightmap;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.snapshot.Snapshotable;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class Chunk
implements Block.Getter,
Block.Setter,
Biome.Getter,
Biome.Setter,
Viewable,
Tickable,
Taggable,
Snapshotable {
    public static final int CHUNK_SIZE_X = 16;
    public static final int CHUNK_SIZE_Z = 16;
    public static final int CHUNK_SECTION_SIZE = 16;
    private final UUID identifier;
    protected Instance instance;
    protected final int chunkX;
    protected final int chunkZ;
    protected final int minSection;
    protected final int maxSection;
    private final boolean shouldGenerate;
    private boolean readOnly;
    protected volatile boolean loaded = true;
    private final Viewable viewable;
    private final TagHandler tagHandler = TagHandler.newHandler();

    public Chunk(Instance instance, int chunkX, int chunkZ, boolean shouldGenerate) {
        List<SharedInstance> list;
        this.identifier = UUID.randomUUID();
        this.instance = instance;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.shouldGenerate = shouldGenerate;
        DimensionType instanceDim = instance.getCachedDimensionType();
        this.minSection = instanceDim.minY() / 16;
        this.maxSection = (instanceDim.minY() + instanceDim.height()) / 16;
        if (instance instanceof InstanceContainer) {
            InstanceContainer instanceContainer = (InstanceContainer)instance;
            list = instanceContainer.getSharedInstances();
        } else {
            list = List.of();
        }
        List<SharedInstance> shared = list;
        this.viewable = instance.getEntityTracker().viewable(shared, chunkX, chunkZ);
    }

    @Override
    public void setBlock(int x, int y, int z, Block block) {
        this.setBlock(x, y, z, block, null, null);
    }

    protected abstract void setBlock(int var1, int var2, int var3, Block var4, @Nullable BlockHandler.Placement var5, @Nullable BlockHandler.Destroy var6);

    public abstract List<Section> getSections();

    public abstract Section getSection(int var1);

    public abstract Heightmap motionBlockingHeightmap();

    public abstract Heightmap worldSurfaceHeightmap();

    public abstract void loadHeightmapsFromNBT(CompoundBinaryTag var1);

    public Section getSectionAt(int blockY) {
        return this.getSection(CoordConversion.globalToChunk(blockY));
    }

    @Override
    public abstract void tick(long var1);

    public void sendChunk(Player player) {
        player.sendChunk(this);
    }

    public void sendChunk() {
        this.getViewers().forEach(this::sendChunk);
    }

    @ApiStatus.Internal
    public abstract SendablePacket getFullDataPacket();

    public abstract Chunk copy(Instance var1, int var2, int var3);

    public abstract void reset();

    public UUID getIdentifier() {
        return this.identifier;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getMinSection() {
        return this.minSection;
    }

    public int getMaxSection() {
        return this.maxSection;
    }

    public Point toPosition() {
        return new Vec(16 * this.getChunkX(), 0.0, 16 * this.getChunkZ());
    }

    public boolean shouldGenerate() {
        return this.shouldGenerate;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void onLoad() {
    }

    public void onGenerate() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.chunkX + ":" + this.chunkZ + "]";
    }

    @Override
    public boolean addViewer(Player player) {
        return this.viewable.addViewer(player);
    }

    @Override
    public boolean removeViewer(Player player) {
        return this.viewable.removeViewer(player);
    }

    @Override
    public Set<Player> getViewers() {
        return this.viewable.getViewers();
    }

    @Override
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    protected void unload() {
        this.loaded = false;
    }

    public abstract void invalidate();
}

