/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.packet.server.play.ExplosionPacket;
import net.minestom.server.particle.Particle;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.PacketSendingUtils;

public abstract class Explosion {
    private final float centerX;
    private final float centerY;
    private final float centerZ;
    private final float strength;

    public Explosion(float centerX, float centerY, float centerZ, float strength) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.strength = strength;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    protected abstract List<Point> prepare(Instance var1);

    public void apply(Instance instance) {
        List<Point> blocks = this.prepare(instance);
        for (Point pos : blocks) {
            instance.setBlock(pos, Block.AIR);
        }
        ExplosionPacket packet = new ExplosionPacket(new Vec(this.centerX, this.centerY, this.centerZ), 0.0f, 0, Vec.ZERO, Particle.EXPLOSION, SoundEvent.ENTITY_GENERIC_EXPLODE, List.of());
        this.postExplosion(instance, blocks, packet);
        PacketSendingUtils.sendGroupedPacket(instance.getPlayers(), packet);
        this.postSend(instance, blocks);
    }

    protected void postExplosion(Instance instance, List<Point> blocks, ExplosionPacket packet) {
    }

    protected void postSend(Instance instance, List<Point> blocks) {
    }
}

