/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.instance.InstanceRegisterEvent;
import net.minestom.server.event.instance.InstanceUnregisterEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.ChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.Nullable;

public final class InstanceManager {
    private final Registries registries;
    private final Set<Instance> instances = new CopyOnWriteArraySet<Instance>();

    public InstanceManager(Registries registries) {
        this.registries = registries;
    }

    public void registerInstance(Instance instance) {
        Check.stateCondition(instance instanceof SharedInstance, "Please use InstanceManager#registerSharedInstance to register a shared instance");
        this.UNSAFE_registerInstance(instance);
    }

    public InstanceContainer createInstanceContainer(RegistryKey<DimensionType> dimensionType, @Nullable ChunkLoader loader) {
        InstanceContainer instanceContainer = new InstanceContainer(this.registries.dimensionType(), UUID.randomUUID(), dimensionType, loader, dimensionType.key());
        this.registerInstance(instanceContainer);
        return instanceContainer;
    }

    public InstanceContainer createInstanceContainer(RegistryKey<DimensionType> dimensionType) {
        return this.createInstanceContainer(dimensionType, null);
    }

    public InstanceContainer createInstanceContainer(@Nullable ChunkLoader loader) {
        return this.createInstanceContainer(DimensionType.OVERWORLD, loader);
    }

    public InstanceContainer createInstanceContainer() {
        return this.createInstanceContainer(DimensionType.OVERWORLD, null);
    }

    public SharedInstance registerSharedInstance(SharedInstance sharedInstance) {
        InstanceContainer instanceContainer = sharedInstance.getInstanceContainer();
        Check.notNull(instanceContainer, "SharedInstance needs to have an InstanceContainer to be created!");
        instanceContainer.addSharedInstance(sharedInstance);
        this.UNSAFE_registerInstance(sharedInstance);
        return sharedInstance;
    }

    public SharedInstance createSharedInstance(InstanceContainer instanceContainer) {
        Check.notNull(instanceContainer, "Instance container cannot be null when creating a SharedInstance!");
        Check.stateCondition(!instanceContainer.isRegistered(), "The container needs to be register in the InstanceManager");
        SharedInstance sharedInstance = new SharedInstance(UUID.randomUUID(), instanceContainer);
        return this.registerSharedInstance(sharedInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInstance(Instance instance) {
        long onlinePlayers = instance.getPlayers().stream().filter(Player::isOnline).count();
        Check.stateCondition(onlinePlayers > 0L, "You cannot unregister an instance with players inside.");
        Instance instance2 = instance;
        synchronized (instance2) {
            InstanceUnregisterEvent event = new InstanceUnregisterEvent(instance);
            EventDispatcher.call(event);
            if (instance instanceof InstanceContainer) {
                instance.getChunks().forEach(instance::unloadChunk);
                ThreadDispatcher<Chunk, Entity> dispatcher = MinecraftServer.process().dispatcher();
                instance.getChunks().forEach(dispatcher::deletePartition);
            }
            instance.setRegistered(false);
            this.instances.remove(instance);
        }
    }

    public Set<Instance> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }

    @Nullable
    public Instance getInstance(UUID uuid) {
        Optional<Instance> instance = this.getInstances().stream().filter(someInstance -> someInstance.getUuid().equals(uuid)).findFirst();
        return instance.orElse(null);
    }

    private void UNSAFE_registerInstance(Instance instance) {
        instance.setRegistered(true);
        this.instances.add(instance);
        ThreadDispatcher<Chunk, Entity> dispatcher = MinecraftServer.process().dispatcher();
        instance.getChunks().forEach(dispatcher::createPartition);
        InstanceRegisterEvent event = new InstanceRegisterEvent(instance);
        EventDispatcher.call(event);
    }
}

