/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Collection;
import java.util.List;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.ChangeGameStatePacket;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;

public record Weather(float rainLevel, float thunderLevel) {
    public static final Weather CLEAR = new Weather(0.0f, 0.0f);
    public static final Weather RAIN = new Weather(1.0f, 0.0f);
    public static final Weather THUNDER = new Weather(1.0f, 1.0f);

    public Weather {
        Check.argCondition(!MathUtils.isBetween(rainLevel, 0.0f, 1.0f), "Rain level should be between 0 and 1");
        Check.argCondition(!MathUtils.isBetween(thunderLevel, 0.0f, 1.0f), "Thunder level should be between 0 and 1");
    }

    @Contract(pure=true)
    public Weather withRainLevel(float rainLevel) {
        return new Weather(rainLevel, this.thunderLevel);
    }

    public boolean isRaining() {
        return this.rainLevel > 0.0f;
    }

    @Contract(pure=true)
    public Weather withRainLevel(FloatUnaryOperator operator) {
        return this.withRainLevel(operator.apply(this.rainLevel));
    }

    @Contract(pure=true)
    public Weather withThunderLevel(float thunderLevel) {
        return new Weather(this.rainLevel, thunderLevel);
    }

    @Contract(pure=true)
    public Weather withThunderLevel(FloatUnaryOperator operator) {
        return this.withRainLevel(operator.apply(this.thunderLevel));
    }

    public ChangeGameStatePacket createIsRainingPacket() {
        return new ChangeGameStatePacket(this.isRaining() ? ChangeGameStatePacket.Reason.BEGIN_RAINING : ChangeGameStatePacket.Reason.END_RAINING, 0.0f);
    }

    public ChangeGameStatePacket createRainLevelPacket() {
        return new ChangeGameStatePacket(ChangeGameStatePacket.Reason.RAIN_LEVEL_CHANGE, this.rainLevel);
    }

    public ChangeGameStatePacket createThunderLevelPacket() {
        return new ChangeGameStatePacket(ChangeGameStatePacket.Reason.THUNDER_LEVEL_CHANGE, this.thunderLevel);
    }

    public Collection<SendablePacket> createWeatherPackets() {
        return List.of(this.createIsRainingPacket(), this.createRainLevelPacket(), this.createThunderLevelPacket());
    }
}

