/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.anvil;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.ChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.anvil.RegionFile;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnvilLoader
implements ChunkLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnvilLoader.class);
    private static final DynamicRegistry<Biome> BIOME_REGISTRY = MinecraftServer.getBiomeRegistry();
    private static final int PLAINS_ID = BIOME_REGISTRY.getId(Biome.PLAINS);
    private static final CompoundBinaryTag[] BLOCK_STATE_ID_2_OBJECT_CACHE = new CompoundBinaryTag[Block.statesCount()];
    private final ReentrantLock fileCreationLock = new ReentrantLock();
    private final Map<String, RegionFile> alreadyLoaded = new ConcurrentHashMap<String, RegionFile>();
    private final Path path;
    private final Path levelPath;
    private final Path regionPath;
    private final Long2ObjectOpenHashMap<LongSet> perRegionLoadedChunks = new Long2ObjectOpenHashMap();
    private final ReentrantLock perRegionLoadedChunksLock = new ReentrantLock();

    public AnvilLoader(Path path) {
        this.path = path;
        this.levelPath = path.resolve("level.dat");
        this.regionPath = path.resolve("region");
    }

    public AnvilLoader(String path) {
        this(Path.of(path, new String[0]));
    }

    @Override
    public void loadInstance(Instance instance) {
        if (!Files.exists(this.levelPath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(this.levelPath, new OpenOption[0]);){
            CompoundBinaryTag tag = BinaryTagIO.reader().readNamed(is, BinaryTagIO.Compression.GZIP).getValue();
            Files.copy(this.levelPath, this.path.resolve("level.dat_old"), StandardCopyOption.REPLACE_EXISTING);
            instance.tagHandler().updateContent(tag);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    @Override
    @Nullable
    public Chunk loadChunk(Instance instance, int chunkX, int chunkZ) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return null;
        }
        try {
            return this.loadMCA(instance, chunkX, chunkZ);
        }
        catch (Exception e) {
            MinecraftServer.getExceptionManager().handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Chunk loadMCA(Instance instance, int chunkX, int chunkZ) throws IOException {
        Chunk chunk;
        RegionFile mcaFile = this.getMCAFile(chunkX, chunkZ);
        if (mcaFile == null) {
            return null;
        }
        CompoundBinaryTag chunkData = mcaFile.readChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return null;
        }
        Chunk chunk2 = chunk = instance.getChunkSupplier().createChunk(instance, chunkX, chunkZ);
        synchronized (chunk2) {
            String status = chunkData.getString("status");
            if (status.isEmpty() || "minecraft:full".equals(status)) {
                this.loadSections(chunk, chunkData);
                this.loadBlockEntities(chunk, chunkData);
                chunk.loadHeightmapsFromNBT(chunkData.getCompound("Heightmaps"));
            } else {
                LOGGER.warn("Skipping partially generated chunk at {}, {} with status {}", chunkX, chunkZ, status);
            }
            CompoundBinaryTag handlerData = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(chunkData)).remove("Heightmaps")).remove("sections")).remove("sections")).remove("block_entities")).build();
            chunk.tagHandler().updateContent(handlerData);
        }
        this.perRegionLoadedChunksLock.lock();
        try {
            int regionX = CoordConversion.chunkToRegion(chunkX);
            int regionZ = CoordConversion.chunkToRegion(chunkZ);
            long regionIndex = CoordConversion.regionIndex(regionX, regionZ);
            LongSet chunks = this.perRegionLoadedChunks.computeIfAbsent(regionIndex, r -> new LongOpenHashSet());
            long chunkIndex = CoordConversion.chunkIndex(chunkX, chunkZ);
            chunks.add(chunkIndex);
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RegionFile getMCAFile(int chunkX, int chunkZ) {
        int regionZ;
        int regionX = CoordConversion.chunkToRegion(chunkX);
        String fileName = RegionFile.getFileName(regionX, regionZ = CoordConversion.chunkToRegion(chunkZ));
        RegionFile loadedFile = this.alreadyLoaded.get(fileName);
        if (loadedFile != null) {
            return loadedFile;
        }
        this.perRegionLoadedChunksLock.lock();
        try {
            RegionFile regionFile = this.alreadyLoaded.computeIfAbsent(fileName, n -> {
                Path regionPath = this.regionPath.resolve((String)n);
                if (!Files.exists(regionPath, new LinkOption[0])) {
                    return null;
                }
                try {
                    long regionIndex = CoordConversion.regionIndex(regionX, regionZ);
                    LongSet previousVersion = this.perRegionLoadedChunks.put(regionIndex, (LongSet)new LongOpenHashSet());
                    assert (previousVersion == null) : "The AnvilLoader cache should not already have data for this region.";
                    return new RegionFile(regionPath);
                }
                catch (IOException e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                    return null;
                }
            });
            return regionFile;
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
    }

    private void loadSections(Chunk chunk, CompoundBinaryTag chunkData) {
        for (BinaryTag sectionTag : chunkData.getList("sections", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag biomesTag;
            ListBinaryTag biomePaletteTag;
            int[] convertedBiomePalette;
            ByteArrayBinaryTag blockLightTag;
            ByteArrayBinaryTag skyLightTag;
            if (!(sectionTag instanceof CompoundBinaryTag)) {
                LOGGER.warn("Invalid section tag in chunk data: {}", (Object)sectionTag);
                continue;
            }
            CompoundBinaryTag sectionData = (CompoundBinaryTag)sectionTag;
            int sectionY = sectionData.getInt("Y", Integer.MIN_VALUE);
            Check.stateCondition(sectionY == Integer.MIN_VALUE, "Missing section Y value");
            if (sectionY < chunk.getMinSection() || sectionY >= chunk.getMaxSection()) continue;
            Section section = chunk.getSection(sectionY);
            BinaryTag binaryTag = sectionData.get("SkyLight");
            if (binaryTag instanceof ByteArrayBinaryTag && (skyLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.skyLight().set(skyLightTag.value());
            }
            if ((binaryTag = sectionData.get("BlockLight")) instanceof ByteArrayBinaryTag && (blockLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.blockLight().set(blockLightTag.value());
            }
            if ((convertedBiomePalette = this.loadBiomePalette(biomePaletteTag = (biomesTag = sectionData.getCompound("biomes")).getList("palette", BinaryTagTypes.STRING))).length == 1) {
                section.biomePalette().fill(convertedBiomePalette[0]);
            } else if (convertedBiomePalette.length > 1) {
                long[] packedIndices = biomesTag.getLongArray("data");
                Check.stateCondition(packedIndices.length == 0, "Missing packed biomes data");
                section.biomePalette().load(convertedBiomePalette, packedIndices);
            }
            CompoundBinaryTag blockStatesTag = sectionData.getCompound("block_states");
            ListBinaryTag blockPaletteTag = blockStatesTag.getList("palette", BinaryTagTypes.COMPOUND);
            int[] convertedPalette = this.loadBlockPalette(blockPaletteTag);
            if (blockPaletteTag.size() == 1) {
                section.blockPalette().fill(convertedPalette[0]);
                continue;
            }
            if (blockPaletteTag.size() <= 1) continue;
            long[] packedStates = blockStatesTag.getLongArray("data");
            Check.stateCondition(packedStates.length == 0, "Missing packed states data");
            section.blockPalette().load(convertedPalette, packedStates);
        }
    }

    private int[] loadBlockPalette(ListBinaryTag paletteTag) {
        int length = paletteTag.size();
        int[] convertedPalette = new int[length];
        for (int i = 0; i < length; ++i) {
            CompoundBinaryTag paletteEntry = paletteTag.getCompound(i);
            String blockName = paletteEntry.getString("Name");
            if (blockName.equals("minecraft:air")) {
                convertedPalette[i] = Block.AIR.stateId();
                continue;
            }
            Block block = Objects.requireNonNull(Block.fromKey(blockName), "Unknown block " + blockName);
            CompoundBinaryTag propertiesNBT = paletteEntry.getCompound("Properties");
            if (!propertiesNBT.isEmpty()) {
                HashMap<String, String> properties = HashMap.newHashMap(propertiesNBT.size());
                for (Map.Entry property : propertiesNBT) {
                    Object v = property.getValue();
                    if (v instanceof StringBinaryTag) {
                        StringBinaryTag propertyValue = (StringBinaryTag)v;
                        properties.put((String)property.getKey(), propertyValue.value());
                        continue;
                    }
                    try {
                        LOGGER.warn("Fail to parse block state properties {}, expected a string tag for {}, but contents were {}", propertiesNBT, property.getKey(), MinestomAdventure.tagStringIO().asString((BinaryTag)property.getValue()));
                    }
                    catch (IOException e) {
                        LOGGER.warn("Fail to parse block state properties {}, expected a string tag for {}, but contents were a {} tag", propertiesNBT, property.getKey(), ((BinaryTag)property.getValue()).examinableName());
                    }
                }
                block = block.withProperties(properties);
            }
            convertedPalette[i] = block.stateId();
        }
        return convertedPalette;
    }

    private int[] loadBiomePalette(ListBinaryTag paletteTag) {
        int length = paletteTag.size();
        int[] convertedPalette = new int[length];
        for (int i = 0; i < length; ++i) {
            String name = paletteTag.getString(i);
            int biomeId = BIOME_REGISTRY.getId(RegistryKey.unsafeOf(name));
            if (biomeId == -1) {
                biomeId = PLAINS_ID;
            }
            convertedPalette[i] = biomeId;
        }
        return convertedPalette;
    }

    private void loadBlockEntities(Chunk loadedChunk, CompoundBinaryTag chunkData) {
        for (BinaryTag blockEntityTag : chunkData.getList("block_entities", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag trimmedTag;
            if (!(blockEntityTag instanceof CompoundBinaryTag)) {
                LOGGER.warn("Invalid block entity tag in chunk data: {}", (Object)blockEntityTag);
                continue;
            }
            CompoundBinaryTag blockEntity = (CompoundBinaryTag)blockEntityTag;
            int x = blockEntity.getInt("x");
            int y = blockEntity.getInt("y");
            int z = blockEntity.getInt("z");
            int localX = CoordConversion.globalToSectionRelative(x);
            int localY = CoordConversion.globalToSectionRelative(y);
            int localZ = CoordConversion.globalToSectionRelative(z);
            Section section = loadedChunk.getSectionAt(y);
            int stateId = section.blockPalette().get(localX, localY, localZ);
            Block block = Block.fromStateId(stateId);
            assert (block != null);
            BinaryTag binaryTag = blockEntity.get("id");
            if (binaryTag instanceof StringBinaryTag) {
                StringBinaryTag blockEntityId = (StringBinaryTag)binaryTag;
                BlockHandler handler = MinecraftServer.getBlockManager().getHandlerOrDummy(blockEntityId.value());
                block = block.withHandler(handler);
            }
            Block finalBlock = !(trimmedTag = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(blockEntity)).remove("id")).remove("keepPacked")).remove("x")).remove("y")).remove("z")).build()).isEmpty() ? block.withNbt(trimmedTag) : block;
            loadedChunk.setBlock(x, y, z, finalBlock);
        }
    }

    @Override
    public void saveInstance(Instance instance) {
        CompoundBinaryTag nbt = instance.tagHandler().asCompound();
        if (nbt.isEmpty()) {
            return;
        }
        try (OutputStream os = Files.newOutputStream(this.levelPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            BinaryTagIO.writer().writeNamed(Map.entry("", nbt), os, BinaryTagIO.Compression.GZIP);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChunk(Chunk chunk) {
        RegionFile mcaFile;
        int chunkZ;
        int chunkX;
        block16: {
            chunkX = chunk.getChunkX();
            chunkZ = chunk.getChunkZ();
            int regionX = CoordConversion.chunkToRegion(chunkX);
            int regionZ = CoordConversion.chunkToRegion(chunkZ);
            long chunkIndex = CoordConversion.chunkIndex(chunkX, chunkZ);
            long regionIndex = CoordConversion.regionIndex(regionX, regionZ);
            this.fileCreationLock.lock();
            try {
                mcaFile = this.getMCAFile(chunkX, chunkZ);
                if (mcaFile != null) break block16;
                String regionFileName = RegionFile.getFileName(regionX, regionZ);
                try {
                    Path regionFile = this.regionPath.resolve(regionFileName);
                    if (!Files.exists(regionFile, new LinkOption[0])) {
                        Files.createDirectories(regionFile.getParent(), new FileAttribute[0]);
                        Files.createFile(regionFile, new FileAttribute[0]);
                    }
                    mcaFile = new RegionFile(regionFile);
                    this.alreadyLoaded.put(regionFileName, mcaFile);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create region file for {}, {}", chunkX, chunkZ, e);
                    MinecraftServer.getExceptionManager().handleException(e);
                    this.fileCreationLock.unlock();
                    this.perRegionLoadedChunksLock.lock();
                    try {
                        this.perRegionLoadedChunks.computeIfAbsent(regionIndex, k -> new LongOpenHashSet()).add(chunkIndex);
                    }
                    finally {
                        this.perRegionLoadedChunksLock.unlock();
                    }
                    return;
                }
            }
            finally {
                this.fileCreationLock.unlock();
                this.perRegionLoadedChunksLock.lock();
                try {
                    this.perRegionLoadedChunks.computeIfAbsent(regionIndex, k -> new LongOpenHashSet()).add(chunkIndex);
                }
                finally {
                    this.perRegionLoadedChunksLock.unlock();
                }
            }
        }
        try {
            CompoundBinaryTag.Builder chunkData = CompoundBinaryTag.builder();
            chunkData.put(chunk.tagHandler().asCompound());
            chunkData.putInt("DataVersion", 4556);
            chunkData.putInt("xPos", chunkX);
            chunkData.putInt("zPos", chunkZ);
            chunkData.putInt("yPos", chunk.getMinSection());
            chunkData.putString("status", "minecraft:full");
            chunkData.putLong("LastUpdate", chunk.getInstance().getWorldAge());
            this.saveSectionData(chunk, chunkData);
            mcaFile.writeChunkData(chunkX, chunkZ, chunkData.build());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save chunk {}, {}", chunkX, chunkZ, e);
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSectionData(Chunk chunk, CompoundBinaryTag.Builder chunkData) {
        ListBinaryTag.Builder<CompoundBinaryTag> sections = ListBinaryTag.builder(BinaryTagTypes.COMPOUND);
        ListBinaryTag.Builder<CompoundBinaryTag> blockEntities = ListBinaryTag.builder(BinaryTagTypes.COMPOUND);
        ArrayList<BinaryTag> biomePalette = new ArrayList<BinaryTag>();
        int[] biomeIndices = new int[64];
        ArrayList<BinaryTag> blockPaletteEntries = new ArrayList<BinaryTag>();
        IntArrayList blockPaletteIndices = new IntArrayList();
        int[] blockIndices = new int[4096];
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            for (int sectionY = chunk.getMinSection(); sectionY < chunk.getMaxSection(); ++sectionY) {
                byte[] blockLight;
                Section section = chunk.getSection(sectionY);
                CompoundBinaryTag.Builder sectionData = CompoundBinaryTag.builder();
                sectionData.putByte("Y", (byte)sectionY);
                byte[] skyLight = section.skyLight().array();
                if (skyLight != null && skyLight.length > 0) {
                    sectionData.putByteArray("SkyLight", skyLight);
                }
                if ((blockLight = section.blockLight().array()) != null && blockLight.length > 0) {
                    sectionData.putByteArray("BlockLight", blockLight);
                }
                int globalSectionY = sectionY * 16;
                if (section.blockPalette().singleValue() != -1) {
                    Block block = Block.fromStateId(section.blockPalette().singleValue());
                    assert (block != null);
                    CompoundBinaryTag blockState = AnvilLoader.blockStateNbt(block);
                    blockPaletteEntries.add(blockState);
                } else {
                    section.blockPalette().getAll((x, y, z, value) -> {
                        Block block = chunk.getBlock(x, globalSectionY + y, z, Block.Getter.Condition.CACHED);
                        if (block == null) {
                            block = Block.fromStateId(value);
                        }
                        assert (block != null);
                        CompoundBinaryTag blockState = AnvilLoader.blockStateNbt(block);
                        int blockPaletteIndex = blockPaletteIndices.indexOf(value);
                        if (blockPaletteIndex == -1) {
                            blockPaletteIndex = blockPaletteEntries.size();
                            blockPaletteEntries.add(blockState);
                            blockPaletteIndices.add(value);
                        }
                        int blockIndex = x + y * 16 * 16 + z * 16;
                        blockIndices[blockIndex] = blockPaletteIndex;
                        BlockHandler handler = block.handler();
                        CompoundBinaryTag originalNBT = block.nbt();
                        if (originalNBT != null || handler != null) {
                            CompoundBinaryTag.Builder blockEntityTag = CompoundBinaryTag.builder();
                            if (originalNBT != null) {
                                blockEntityTag.put(originalNBT);
                            }
                            if (handler != null) {
                                blockEntityTag.putString("id", handler.getKey().asString());
                            }
                            blockEntityTag.putInt("x", x + 16 * chunk.getChunkX());
                            blockEntityTag.putInt("y", y + globalSectionY);
                            blockEntityTag.putInt("z", z + 16 * chunk.getChunkZ());
                            blockEntityTag.putByte("keepPacked", (byte)0);
                            blockEntities.add(blockEntityTag.build());
                        }
                    });
                }
                if (section.biomePalette().singleValue() != -1) {
                    RegistryKey<Biome> biomeKey = MinecraftServer.getBiomeRegistry().getKey((Biome)section.biomePalette().singleValue());
                    assert (biomeKey != null);
                    StringBinaryTag biomeName = StringBinaryTag.stringBinaryTag(biomeKey.key().asString());
                    biomePalette.add(biomeName);
                } else {
                    section.biomePalette().getAll((x, y, z, value) -> {
                        int biomeIndex = x + y * 4 * 4 + z * 4;
                        RegistryKey<Biome> biomeKey = MinecraftServer.getBiomeRegistry().getKey((Biome)value);
                        assert (biomeKey != null);
                        StringBinaryTag biomeName = StringBinaryTag.stringBinaryTag(biomeKey.key().asString());
                        int biomePaletteIndex = biomePalette.indexOf(biomeName);
                        if (biomePaletteIndex == -1) {
                            biomePaletteIndex = biomePalette.size();
                            biomePalette.add(biomeName);
                        }
                        biomeIndices[biomeIndex] = biomePaletteIndex;
                    });
                }
                CompoundBinaryTag.Builder blockStates = CompoundBinaryTag.builder();
                blockStates.put("palette", ListBinaryTag.listBinaryTag(BinaryTagTypes.COMPOUND, blockPaletteEntries));
                if (blockPaletteEntries.size() > 1) {
                    int bitsPerEntry = Math.max(4, MathUtils.bitsToRepresent(blockPaletteEntries.size() - 1));
                    blockStates.putLongArray("data", Palettes.pack(blockIndices, bitsPerEntry));
                }
                sectionData.put("block_states", blockStates.build());
                CompoundBinaryTag.Builder biomes = CompoundBinaryTag.builder();
                biomes.put("palette", ListBinaryTag.listBinaryTag(BinaryTagTypes.STRING, biomePalette));
                if (biomePalette.size() > 1) {
                    int bitsPerEntry = MathUtils.bitsToRepresent(biomePalette.size() - 1);
                    biomes.putLongArray("data", Palettes.pack(biomeIndices, bitsPerEntry));
                }
                sectionData.put("biomes", biomes.build());
                biomePalette.clear();
                blockPaletteEntries.clear();
                blockPaletteIndices.clear();
                sections.add(sectionData.build());
            }
        }
        chunkData.put("sections", sections.build());
        chunkData.put("block_entities", blockEntities.build());
    }

    private static CompoundBinaryTag blockStateNbt(Block block) {
        int stateId = block.stateId();
        CompoundBinaryTag result = BLOCK_STATE_ID_2_OBJECT_CACHE[stateId];
        if (result == null) {
            result = AnvilLoader.BLOCK_STATE_ID_2_OBJECT_CACHE[stateId] = AnvilLoader.blockStateNbtCompute(block);
        }
        return result;
    }

    private static CompoundBinaryTag blockStateNbtCompute(Block block) {
        CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
        tag.putString("Name", block.name());
        if (!block.properties().isEmpty()) {
            Map<String, String> defaultProperties = block.defaultState().properties();
            CompoundBinaryTag.Builder propertiesTag = CompoundBinaryTag.builder();
            for (Map.Entry<String, String> entry : block.properties().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (defaultProperties.get(key).equals(value)) continue;
                propertiesTag.putString(key, value);
            }
            CompoundBinaryTag properties = propertiesTag.build();
            if (!properties.isEmpty()) {
                tag.put("Properties", properties);
            }
        }
        return tag.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadChunk(Chunk chunk) {
        int regionX = CoordConversion.chunkToRegion(chunk.getChunkX());
        int regionZ = CoordConversion.chunkToRegion(chunk.getChunkZ());
        long regionIndex = CoordConversion.regionIndex(regionX, regionZ);
        this.perRegionLoadedChunksLock.lock();
        try {
            LongSet chunks = this.perRegionLoadedChunks.get(regionIndex);
            if (chunks != null) {
                long chunkIndex = CoordConversion.chunkIndex(chunk.getChunkX(), chunk.getChunkZ());
                chunks.remove(chunkIndex);
                if (chunks.isEmpty()) {
                    this.perRegionLoadedChunks.remove(regionIndex);
                    RegionFile regionFile = this.alreadyLoaded.remove(RegionFile.getFileName(regionX, regionZ));
                    if (regionFile != null) {
                        try {
                            regionFile.close();
                        }
                        catch (IOException e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
    }

    @Override
    public boolean supportsParallelLoading() {
        return true;
    }

    @Override
    public boolean supportsParallelSaving() {
        return true;
    }
}

