/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.Area;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.block.BlockImpl;
import net.minestom.server.instance.block.Blocks;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface Block
extends StaticProtocolObject<Block>,
TagReadable,
Blocks
permits BlockImpl {
    public static final NetworkBuffer.Type<Block> ID_NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(Block::fromBlockId, Block::id);
    public static final NetworkBuffer.Type<Block> STATE_NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(Block::fromStateId, Block::stateId);

    @Contract(pure=true)
    public Block withProperty(String var1, String var2);

    @Contract(pure=true)
    public Block withProperties(Map<String, String> var1);

    @Contract(pure=true)
    public <T> Block withTag(Tag<T> var1, @Nullable T var2);

    @Contract(pure=true)
    public Block withNbt(@Nullable CompoundBinaryTag var1);

    @Contract(pure=true)
    public Block withHandler(@Nullable BlockHandler var1);

    @Contract(pure=true)
    @Nullable
    public CompoundBinaryTag nbt();

    default public CompoundBinaryTag nbtOrEmpty() {
        return Objects.requireNonNullElse(this.nbt(), CompoundBinaryTag.empty());
    }

    @Contract(pure=true)
    default public boolean hasNbt() {
        return this.nbt() != null;
    }

    @Contract(pure=true)
    @Nullable
    public BlockHandler handler();

    @Contract(pure=true)
    public @Unmodifiable Map<String, String> properties();

    @Contract(pure=true)
    public String state();

    @Contract(pure=true)
    public Block defaultState();

    @Contract(pure=true)
    @Nullable
    public String getProperty(String var1);

    @Contract(pure=true)
    public Collection<Block> possibleStates();

    @Override
    @Contract(pure=true)
    public RegistryData.BlockEntry registry();

    @Override
    default public Key key() {
        return this.registry().key();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public int stateId() {
        return this.registry().stateId();
    }

    default public boolean isAir() {
        return this.registry().isAir();
    }

    default public boolean isSolid() {
        return this.registry().isSolid();
    }

    default public boolean isLiquid() {
        return this.registry().isLiquid();
    }

    default public boolean compare(Block block, Comparator comparator) {
        return comparator.test(this, block);
    }

    default public boolean compare(Block block) {
        return this.compare(block, Comparator.ID);
    }

    public static Collection<Block> values() {
        return BlockImpl.REGISTRY.values();
    }

    @Nullable
    public static Block fromKey(@KeyPattern String key) {
        return Block.fromKey(Key.key(key));
    }

    @Nullable
    public static Block fromKey(Key key) {
        return BlockImpl.REGISTRY.get(key);
    }

    @Nullable
    public static Block fromState(String state) {
        return BlockImpl.parseState(state);
    }

    public static int statesCount() {
        return BlockImpl.statesCount();
    }

    @Nullable
    public static Block fromStateId(int stateId) {
        return BlockImpl.getState(stateId);
    }

    @Nullable
    public static Block fromBlockId(int blockId) {
        return BlockImpl.REGISTRY.get(blockId);
    }

    public static Registry<Block> staticRegistry() {
        return BlockImpl.REGISTRY;
    }

    @FunctionalInterface
    public static interface Comparator
    extends BiPredicate<Block, Block> {
        public static final Comparator IDENTITY = (b1, b2) -> b1 == b2;
        public static final Comparator ID = (b1, b2) -> b1.id() == b2.id();
        public static final Comparator STATE = (b1, b2) -> b1.stateId() == b2.stateId();
    }

    public static interface Getter {
        public @UnknownNullability Block getBlock(int var1, int var2, int var3, Condition var4);

        default public @UnknownNullability Block getBlock(Point point, Condition condition) {
            return this.getBlock(point.blockX(), point.blockY(), point.blockZ(), condition);
        }

        default public Block getBlock(int x, int y, int z) {
            return Objects.requireNonNull(this.getBlock(x, y, z, Condition.NONE));
        }

        default public Block getBlock(Point point) {
            return Objects.requireNonNull(this.getBlock(point, Condition.NONE));
        }

        public static enum Condition {
            NONE,
            CACHED,
            TYPE;

        }
    }

    public static interface Setter {
        public void setBlock(int var1, int var2, int var3, Block var4);

        default public void setBlock(Point blockPosition, Block block) {
            this.setBlock(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), block);
        }

        default public void setBlockArea(Area area, Block block) {
            for (BlockVec vec : area) {
                this.setBlock(vec.blockX(), vec.blockY(), vec.blockZ(), block);
            }
        }
    }
}

