/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.heightmap;

import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.MathUtils;

public abstract class Heightmap {
    private final short[] heights = new short[256];
    private final Chunk chunk;
    private final int minHeight;
    private boolean needsRefresh = true;

    public Heightmap(Chunk chunk) {
        this.chunk = chunk;
        this.minHeight = chunk.getInstance().getCachedDimensionType().minY() - 1;
    }

    public abstract Type type();

    protected abstract boolean checkBlock(Block var1);

    public void refresh(int x, int y, int z, Block block) {
        int height = this.getHeight(x, z);
        if (this.checkBlock(block)) {
            if (height < y) {
                this.setHeightY(x, z, y);
            }
        } else if (y == height) {
            this.refresh(x, z, y - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(int startY) {
        if (!this.needsRefresh) {
            return;
        }
        Chunk chunk = this.chunk;
        synchronized (chunk) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.refresh(x, z, startY);
                }
            }
        }
        this.needsRefresh = false;
    }

    public void refresh(int x, int z, int startY) {
        int localX = CoordConversion.globalToSectionRelative(x);
        int localZ = CoordConversion.globalToSectionRelative(z);
        int foundHeight = this.minHeight;
        int currentY = startY;
        while (currentY > this.minHeight) {
            int sectionY = CoordConversion.globalToChunk(currentY);
            if (sectionY < this.chunk.getMinSection() || sectionY >= this.chunk.getMaxSection()) {
                currentY = (sectionY << 4) - 1;
                continue;
            }
            Palette blockPalette = this.chunk.getSection(sectionY).blockPalette();
            int localHeight = blockPalette.height(localX, localZ, (px, py, pz, value) -> {
                if (value == 0) {
                    return false;
                }
                Block block = Block.fromStateId(value);
                return block != null && this.checkBlock(block);
            });
            if (localHeight >= 0) {
                foundHeight = (sectionY << 4) + localHeight;
                break;
            }
            currentY = (sectionY << 4) - 1;
        }
        this.setHeightY(x, z, foundHeight);
    }

    public long[] getNBT() {
        int dimensionHeight = this.chunk.getInstance().getCachedDimensionType().height();
        int bitsForHeight = MathUtils.bitsToRepresent(dimensionHeight);
        return Heightmap.encode(this.heights, bitsForHeight);
    }

    public void loadFrom(long[] data) {
        int dimensionHeight = this.chunk.getInstance().getCachedDimensionType().height();
        int bitsPerEntry = MathUtils.bitsToRepresent(dimensionHeight);
        int entriesPerLong = 64 / bitsPerEntry;
        int maxPossibleIndexInContainer = entriesPerLong - 1;
        int entryMask = (1 << bitsPerEntry) - 1;
        int containerIndex = 0;
        for (int i = 0; i < this.heights.length; ++i) {
            int indexInContainer = i % entriesPerLong;
            this.heights[i] = (short)((int)(data[containerIndex] >> indexInContainer * bitsPerEntry) & entryMask);
            if (indexInContainer != maxPossibleIndexInContainer) continue;
            ++containerIndex;
        }
        this.needsRefresh = false;
    }

    public int getHeight(int x, int z) {
        if (this.needsRefresh) {
            this.refresh(Heightmap.getHighestBlockSection(this.chunk));
        }
        return this.heights[z << 4 | x] + this.minHeight;
    }

    private void setHeightY(int x, int z, int height) {
        this.heights[z << 4 | x] = (short)(height - this.minHeight);
    }

    public static int getHighestBlockSection(Chunk chunk) {
        int sectionY;
        Palette blockPalette;
        int y = chunk.getInstance().getCachedDimensionType().maxY();
        int sectionsCount = chunk.getMaxSection() - chunk.getMinSection();
        for (int i = 0; i < sectionsCount && (blockPalette = chunk.getSection(sectionY = chunk.getMaxSection() - i - 1).blockPalette()).count() == 0; ++i) {
            y -= 16;
        }
        return y;
    }

    static long[] encode(short[] heights, int bitsPerEntry) {
        int entriesPerLong = 64 / bitsPerEntry;
        int len = (heights.length + entriesPerLong - 1) / entriesPerLong;
        int maxPossibleIndexInContainer = entriesPerLong - 1;
        int entryMask = (1 << bitsPerEntry) - 1;
        long[] data = new long[len];
        int containerIndex = 0;
        for (int i = 0; i < heights.length; ++i) {
            int indexInContainer = i % entriesPerLong;
            short entry = heights[i];
            int n = containerIndex++;
            data[n] = data[n] | (long)(entry & entryMask) << indexInContainer * bitsPerEntry;
            if (indexInContainer != maxPossibleIndexInContainer) continue;
        }
        return data;
    }

    public static enum Type {
        WORLD_SURFACE_WG,
        WORLD_SURFACE,
        OCEAN_FLOOR_WG,
        OCEAN_FLOOR,
        MOTION_BLOCKING,
        MOTION_BLOCKING_NO_LEAVES;

        public static final NetworkBuffer.Type<Type> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Type.class);
        }
    }
}

