/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.palette.Palette;
import org.jetbrains.annotations.ApiStatus;

final class BlockLight
implements Light {
    private byte[] content;
    private byte[] contentPropagation;
    private byte[] contentPropagationSwap;
    private volatile boolean isValidBorders = true;
    private final AtomicBoolean needsSend = new AtomicBoolean(false);

    BlockLight() {
    }

    @Override
    public void flip() {
        if (this.contentPropagationSwap != null) {
            this.contentPropagation = this.contentPropagationSwap;
        }
        this.contentPropagationSwap = null;
    }

    static ShortArrayFIFOQueue buildInternalQueue(Palette blockPalette) {
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        blockPalette.getAllPresent((x, y, z, stateId) -> {
            Block block = Block.fromStateId(stateId);
            assert (block != null);
            byte lightEmission = (byte)block.registry().lightEmission();
            int index = x | z << 4 | y << 8;
            if (lightEmission > 0) {
                lightSources.enqueue((short)(index | lightEmission << 12));
            }
        });
        return lightSources;
    }

    @Override
    public void invalidate() {
        this.needsSend.set(true);
        this.isValidBorders = false;
        this.contentPropagation = null;
    }

    @Override
    public boolean requiresUpdate() {
        return !this.isValidBorders;
    }

    @Override
    @ApiStatus.Internal
    public void set(byte[] copyArray) {
        this.content = LightCompute.lazyArray(copyArray);
        this.contentPropagation = this.content;
        this.isValidBorders = true;
        this.needsSend.set(true);
    }

    @Override
    public boolean requiresSend() {
        return this.needsSend.getAndSet(false);
    }

    @Override
    public byte[] array() {
        if (this.content == null) {
            return LightCompute.UNSET_CONTENT;
        }
        if (this.contentPropagation == null) {
            return this.content;
        }
        byte[] res = LightCompute.bake(this.contentPropagation, this.content);
        if (res == LightCompute.EMPTY_CONTENT) {
            return LightCompute.UNSET_CONTENT;
        }
        return res;
    }

    @Override
    public int getLevel(int x, int y, int z) {
        if (this.content == null) {
            return 0;
        }
        int index = x | z << 4 | y << 8;
        if (this.contentPropagation == null) {
            return LightCompute.getLight(this.content, index);
        }
        return Math.max(LightCompute.getLight(this.contentPropagation, index), LightCompute.getLight(this.content, index));
    }

    @Override
    public Set<Point> calculateInternal(Palette blockPalette, int chunkX, int chunkY, int chunkZ, int[] heightmap, int maxY, Light.LightLookup lightLookup) {
        this.isValidBorders = true;
        ShortArrayFIFOQueue queue = BlockLight.buildInternalQueue(blockPalette);
        this.content = LightCompute.compute(blockPalette, queue);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    int neighborX = chunkX + i;
                    int neighborY = chunkY + j;
                    int neighborZ = chunkZ + k;
                    Light light = lightLookup.light(neighborX, neighborY, neighborZ);
                    if (!(light instanceof BlockLight)) continue;
                    BlockLight blockLight = (BlockLight)light;
                    blockLight.contentPropagation = null;
                }
            }
        }
        return Set.of(new BlockVec(chunkX, chunkY, chunkZ));
    }

    @Override
    public Set<Point> calculateExternal(Palette blockPalette, Point[] neighbors, Light.LightLookup lightLookup, Light.PaletteLookup paletteLookup) {
        if (!this.isValidBorders) {
            return Set.of();
        }
        ShortArrayFIFOQueue queue = LightCompute.buildExternalQueue(blockPalette, neighbors, this.content, lightLookup, paletteLookup);
        byte[] contentPropagationTemp = LightCompute.compute(blockPalette, queue);
        this.contentPropagationSwap = LightCompute.bake(this.contentPropagationSwap, contentPropagationTemp);
        HashSet<Point> toUpdate = new HashSet<Point>();
        for (int i = 0; i < neighbors.length; ++i) {
            BlockFace face;
            Point neighbor = neighbors[i];
            if (neighbor == null || LightCompute.compareBorders(this.content, this.contentPropagation, contentPropagationTemp, face = LightCompute.FACES[i])) continue;
            toUpdate.add(neighbor);
        }
        return toUpdate;
    }
}

