/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class PaletteImpl
implements Palette {
    private static final ThreadLocal<int[]> WRITE_CACHE = ThreadLocal.withInitial(() -> new int[4096]);
    final byte dimension;
    final byte minBitsPerEntry;
    final byte maxBitsPerEntry;
    final byte directBits;
    byte bitsPerEntry = 0;
    int count = 0;
    long @UnknownNullability [] values;
    @UnknownNullability IntArrayList paletteToValueList;
    @UnknownNullability Int2IntOpenHashMap valueToPaletteMap;

    PaletteImpl(byte dimension, byte minBitsPerEntry, byte maxBitsPerEntry, byte directBits) {
        PaletteImpl.validateDimension(dimension);
        this.dimension = dimension;
        this.minBitsPerEntry = minBitsPerEntry;
        this.maxBitsPerEntry = maxBitsPerEntry;
        this.directBits = directBits;
    }

    PaletteImpl(byte dimension, byte minBitsPerEntry, byte maxBitsPerEntry, byte directBits, byte bitsPerEntry) {
        this(dimension, minBitsPerEntry, maxBitsPerEntry, directBits);
        this.bitsPerEntry = bitsPerEntry;
        if (bitsPerEntry != 0) {
            this.values = new long[Palettes.arrayLength(dimension, bitsPerEntry)];
            if (this.hasPalette()) {
                this.paletteToValueList = new IntArrayList();
                this.valueToPaletteMap = new Int2IntOpenHashMap();
                this.valueToPaletteMap.defaultReturnValue(-1);
                this.paletteToValueList.add(0);
                this.valueToPaletteMap.put(0, 0);
            }
        }
    }

    @Override
    public int get(int x, int y, int z) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        if (this.bitsPerEntry == 0) {
            return this.count;
        }
        int value = Palettes.read(this.dimension(), this.bitsPerEntry, this.values, x, y, z);
        return this.paletteIndexToValue(value);
    }

    @Override
    public void getAll(Palette.EntryConsumer consumer) {
        if (this.bitsPerEntry == 0) {
            Palettes.getAllFill(this.dimension, this.count, consumer);
        } else {
            this.retrieveAll(consumer, true);
        }
    }

    @Override
    public void getAllPresent(Palette.EntryConsumer consumer) {
        if (this.bitsPerEntry == 0) {
            if (this.count != 0) {
                Palettes.getAllFill(this.dimension, this.count, consumer);
            }
        } else {
            this.retrieveAll(consumer, false);
        }
    }

    @Override
    public int height(int x, int z, Palette.EntryPredicate predicate) {
        PaletteImpl.validateCoord(this.dimension, x, 0, z);
        byte dimension = this.dimension;
        int startY = dimension - 1;
        if (this.bitsPerEntry == 0) {
            return predicate.get(x, startY, z, this.count) ? startY : -1;
        }
        long[] values = this.values;
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        int mask = (1 << bitsPerEntry) - 1;
        int[] paletteIds = this.hasPalette() ? this.paletteToValueList.elements() : null;
        for (int y = startY; y >= 0; --y) {
            int value;
            int index = Palettes.sectionIndex(dimension, x, y, z);
            int longIndex = index / valuesPerLong;
            int bitIndex = index % valuesPerLong * bitsPerEntry;
            int paletteIndex = (int)(values[longIndex] >> bitIndex) & mask;
            int n = value = paletteIds != null && paletteIndex < paletteIds.length ? paletteIds[paletteIndex] : paletteIndex;
            if (!predicate.get(x, y, z, value)) continue;
            return y;
        }
        return -1;
    }

    @Override
    public void set(int x, int y, int z, int value) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        int paletteIndex = this.valueToPaletteIndex(value);
        int oldValue = Palettes.write(this.dimension(), this.bitsPerEntry, this.values, x, y, z, paletteIndex);
        boolean currentAir = this.paletteIndexToValue(oldValue) == 0;
        if (currentAir != (value == 0)) {
            this.count += currentAir ? 1 : -1;
        }
    }

    @Override
    public void fill(int value) {
        this.bitsPerEntry = 0;
        this.count = value;
        this.values = null;
        this.paletteToValueList = null;
        this.valueToPaletteMap = null;
    }

    @Override
    public void load(int[] palette, long[] values) {
        boolean useDirectMode;
        int bpe = palette.length <= 1 ? 0 : MathUtils.bitsToRepresent(palette.length - 1);
        bpe = Math.max(this.minBitsPerEntry, bpe);
        boolean bl = useDirectMode = bpe > this.maxBitsPerEntry;
        if (useDirectMode) {
            bpe = this.directBits;
        }
        this.bitsPerEntry = (byte)bpe;
        if (useDirectMode) {
            this.paletteToValueList = null;
            this.valueToPaletteMap = null;
            this.values = new long[Palettes.arrayLength(this.dimension, this.directBits)];
            int originalBpe = palette.length <= 1 ? 0 : MathUtils.bitsToRepresent(palette.length - 1);
            int actualOriginalBpe = Math.max(this.minBitsPerEntry, originalBpe);
            int originalMask = (1 << actualOriginalBpe) - 1;
            int originalValuesPerLong = 64 / actualOriginalBpe;
            int nonZeroCount = 0;
            int dimension = this.dimension;
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    for (int x = 0; x < dimension; ++x) {
                        int directValue;
                        int bitIndex;
                        int index = Palettes.sectionIndex(dimension, x, y, z);
                        int longIndex = index / originalValuesPerLong;
                        int paletteIndex = (int)(values[longIndex] >> (bitIndex = index % originalValuesPerLong * actualOriginalBpe)) & originalMask;
                        int n = directValue = paletteIndex < palette.length ? palette[paletteIndex] : 0;
                        if (directValue != 0) {
                            ++nonZeroCount;
                        }
                        Palettes.write(dimension, this.directBits, this.values, x, y, z, directValue);
                    }
                }
            }
            this.count = nonZeroCount;
        } else {
            this.paletteToValueList = new IntArrayList(palette);
            this.valueToPaletteMap = new Int2IntOpenHashMap(palette.length);
            this.valueToPaletteMap.defaultReturnValue(-1);
            for (int i = 0; i < palette.length; ++i) {
                this.valueToPaletteMap.put(palette[i], i);
            }
            this.values = Arrays.copyOf(values, Palettes.arrayLength(this.dimension, this.bitsPerEntry));
            this.recount();
        }
    }

    @Override
    public void offset(int offset) {
        if (offset == 0) {
            return;
        }
        if (this.bitsPerEntry == 0) {
            this.count += offset;
        } else {
            this.replaceAll((x, y, z, value) -> value + offset);
        }
    }

    @Override
    public void replace(int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (this.bitsPerEntry == 0) {
            if (oldValue == this.count) {
                this.fill(newValue);
            }
        } else if (this.hasPalette()) {
            int count;
            int index = this.valueToPaletteMap.get(oldValue);
            if (index == -1) {
                return;
            }
            boolean countUpdate = newValue == 0 || oldValue == 0;
            int n = count = countUpdate ? this.count(oldValue) : -1;
            if (count == 0) {
                return;
            }
            this.paletteToValueList.set(index, newValue);
            this.valueToPaletteMap.remove(oldValue);
            this.valueToPaletteMap.put(newValue, index);
            if (newValue == 0) {
                this.count -= count;
            } else if (oldValue == 0) {
                this.count += count;
            }
        } else {
            this.replaceAll((x, y, z, value) -> value == oldValue ? newValue : value);
        }
    }

    @Override
    public void setAll(Palette.EntrySupplier supplier) {
        int[] cache = WRITE_CACHE.get();
        int dimension = this.dimension();
        int fillValue = -1;
        int count = 0;
        int index = 0;
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value = supplier.get(x, y, z);
                    if (fillValue != -2) {
                        if (fillValue == -1) {
                            fillValue = value;
                        } else if (fillValue != value) {
                            fillValue = -2;
                        }
                    }
                    if (value != 0) {
                        ++count;
                    }
                    cache[index++] = value;
                }
            }
        }
        assert (index == this.maxSize());
        if (fillValue < 0) {
            this.makeDirect();
            this.updateAll(cache);
            this.count = count;
        } else {
            this.fill(fillValue);
        }
    }

    @Override
    public void replace(int x, int y, int z, IntUnaryOperator operator) {
        PaletteImpl.validateCoord(this.dimension, x, y, z);
        int oldValue = this.get(x, y, z);
        int newValue = operator.applyAsInt(oldValue);
        if (oldValue != newValue) {
            this.set(x, y, z, newValue);
        }
    }

    @Override
    public void replaceAll(Palette.EntryFunction function) {
        int[] cache = WRITE_CACHE.get();
        AtomicInteger arrayIndex = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        this.getAll((x, y, z, value) -> {
            int newValue = function.apply(x, y, z, value);
            int index = arrayIndex.getPlain();
            arrayIndex.setPlain(index + 1);
            cache[index] = newValue;
            if (newValue != 0) {
                count.setPlain(count.getPlain() + 1);
            }
        });
        assert (arrayIndex.getPlain() == this.maxSize());
        this.makeDirect();
        this.updateAll(cache);
        this.count = count.getPlain();
    }

    @Override
    public void copyFrom(Palette source, int offsetX, int offsetY, int offsetZ) {
        int targetDimension;
        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) {
            this.copyFrom(source);
            return;
        }
        PaletteImpl sourcePalette = (PaletteImpl)source;
        int sourceDimension = sourcePalette.dimension();
        if (sourceDimension != (targetDimension = this.dimension())) {
            throw new IllegalArgumentException("Source palette dimension (" + sourceDimension + ") must equal target palette dimension (" + targetDimension + ")");
        }
        int maxX = Math.min(sourceDimension, targetDimension - offsetX);
        int maxY = Math.min(sourceDimension, targetDimension - offsetY);
        int maxZ = Math.min(sourceDimension, targetDimension - offsetZ);
        if (maxX <= 0 || maxY <= 0 || maxZ <= 0) {
            return;
        }
        if (sourcePalette.bitsPerEntry == 0) {
            int value = sourcePalette.count;
            int paletteValue = this.valueToPaletteIndex(value);
            for (int y = 0; y < maxY; ++y) {
                int targetY = offsetY + y;
                for (int z = 0; z < maxZ; ++z) {
                    int targetZ = offsetZ + z;
                    for (int x = 0; x < maxX; ++x) {
                        boolean isAir;
                        int targetX = offsetX + x;
                        int oldValue = Palettes.write(targetDimension, this.bitsPerEntry, this.values, targetX, targetY, targetZ, paletteValue);
                        boolean wasAir = this.paletteIndexToValue(oldValue) == 0;
                        boolean bl = isAir = value == 0;
                        if (wasAir == isAir) continue;
                        this.count += wasAir ? 1 : -1;
                    }
                }
            }
            return;
        }
        if (sourcePalette.count == 0) {
            if (this.count == 0) {
                return;
            }
            int airPaletteIndex = this.valueToPaletteIndex(0);
            int removedBlocks = 0;
            for (int y = 0; y < maxY; ++y) {
                int targetY = offsetY + y;
                for (int z = 0; z < maxZ; ++z) {
                    int targetZ = offsetZ + z;
                    for (int x = 0; x < maxX; ++x) {
                        int targetX = offsetX + x;
                        int oldValue = Palettes.write(targetDimension, this.bitsPerEntry, this.values, targetX, targetY, targetZ, airPaletteIndex);
                        if (this.paletteIndexToValue(oldValue) == 0) continue;
                        ++removedBlocks;
                    }
                }
            }
            this.count -= removedBlocks;
            return;
        }
        long[] sourceValues = sourcePalette.values;
        byte sourceBitsPerEntry = sourcePalette.bitsPerEntry;
        int sourceMask = (1 << sourceBitsPerEntry) - 1;
        int sourceValuesPerLong = 64 / sourceBitsPerEntry;
        int sourceDimensionBitCount = MathUtils.bitsToRepresent(sourceDimension - 1);
        int sourceShiftedDimensionBitCount = sourceDimensionBitCount << 1;
        int[] sourcePaletteIds = sourcePalette.hasPalette() ? sourcePalette.paletteToValueList.elements() : null;
        int countDelta = 0;
        for (int y = 0; y < maxY; ++y) {
            int targetY = offsetY + y;
            for (int z = 0; z < maxZ; ++z) {
                int targetZ = offsetZ + z;
                for (int x = 0; x < maxX; ++x) {
                    boolean isAir;
                    int targetX = offsetX + x;
                    int sourceIndex = y << sourceShiftedDimensionBitCount | z << sourceDimensionBitCount | x;
                    int longIndex = sourceIndex / sourceValuesPerLong;
                    int bitIndex = (sourceIndex - longIndex * sourceValuesPerLong) * sourceBitsPerEntry;
                    int sourcePaletteIndex = (int)(sourceValues[longIndex] >> bitIndex) & sourceMask;
                    int sourceValue = sourcePaletteIds != null && sourcePaletteIndex < sourcePaletteIds.length ? sourcePaletteIds[sourcePaletteIndex] : sourcePaletteIndex;
                    int targetPaletteIndex = this.valueToPaletteIndex(sourceValue);
                    int oldValue = Palettes.write(targetDimension, this.bitsPerEntry, this.values, targetX, targetY, targetZ, targetPaletteIndex);
                    boolean wasAir = this.paletteIndexToValue(oldValue) == 0;
                    boolean bl = isAir = sourceValue == 0;
                    if (wasAir == isAir) continue;
                    countDelta += wasAir ? 1 : -1;
                }
            }
        }
        this.count += countDelta;
    }

    @Override
    public void copyFrom(Palette source) {
        int targetDimension;
        PaletteImpl sourcePalette = (PaletteImpl)source;
        int sourceDimension = sourcePalette.dimension();
        if (sourceDimension != (targetDimension = this.dimension())) {
            throw new IllegalArgumentException("Source palette dimension (" + sourceDimension + ") must equal target palette dimension (" + targetDimension + ")");
        }
        if (sourcePalette.bitsPerEntry == 0) {
            this.fill(sourcePalette.count);
            return;
        }
        if (sourcePalette.count == 0) {
            this.fill(0);
            return;
        }
        this.bitsPerEntry = sourcePalette.bitsPerEntry;
        this.count = sourcePalette.count;
        this.values = (long[])(sourcePalette.values != null ? (long[])sourcePalette.values.clone() : null);
        this.paletteToValueList = sourcePalette.paletteToValueList != null ? new IntArrayList(sourcePalette.paletteToValueList) : null;
        if (sourcePalette.valueToPaletteMap != null) {
            this.valueToPaletteMap = new Int2IntOpenHashMap(sourcePalette.valueToPaletteMap);
            this.valueToPaletteMap.defaultReturnValue(-1);
        } else {
            this.valueToPaletteMap = null;
        }
    }

    @Override
    public int count() {
        if (this.bitsPerEntry == 0) {
            return this.count == 0 ? 0 : this.maxSize();
        }
        return this.count;
    }

    @Override
    public int count(int value) {
        if (this.bitsPerEntry == 0) {
            return this.count == value ? this.maxSize() : 0;
        }
        if (value == 0) {
            return this.maxSize() - this.count();
        }
        int queryValue = this.valueToPalettIndexOrDefault(value);
        return this.countPaletteIndex(queryValue);
    }

    void recount() {
        if (this.bitsPerEntry != 0) {
            this.count = this.maxSize() - this.countPaletteIndex(this.valueToPalettIndexOrDefault(0));
        }
    }

    int countPaletteIndex(int paletteIndex) {
        if (paletteIndex < 0) {
            return 0;
        }
        int result = 0;
        int size = this.maxSize();
        byte bits = this.bitsPerEntry;
        int valuesPerLong = 64 / bits;
        int mask = (1 << bits) - 1;
        int idx = 0;
        for (int i = 0; i < this.values.length; ++i) {
            long block = this.values[i];
            int end = Math.min(valuesPerLong, size - idx);
            int j = 0;
            while (j < end) {
                if ((int)(block & (long)mask) == paletteIndex) {
                    ++result;
                }
                block >>>= bits;
                ++j;
                ++idx;
            }
        }
        return result;
    }

    @Override
    public boolean any(int value) {
        if (this.bitsPerEntry == 0) {
            return this.count == value;
        }
        if (value == 0) {
            return this.maxSize() != this.count;
        }
        int queryValue = this.valueToPalettIndexOrDefault(value);
        if (queryValue == -1) {
            return false;
        }
        int size = this.maxSize();
        byte bits = this.bitsPerEntry;
        int valuesPerLong = 64 / bits;
        int mask = (1 << bits) - 1;
        int idx = 0;
        for (int i = 0; i < this.values.length; ++i) {
            long block = this.values[i];
            int end = Math.min(valuesPerLong, size - idx);
            int j = 0;
            while (j < end) {
                if ((int)(block & (long)mask) == queryValue) {
                    return true;
                }
                block >>>= bits;
                ++j;
                ++idx;
            }
        }
        return false;
    }

    @Override
    public int bitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public void optimize(Palette.Optimization focus) {
        byte bitsPerEntry = this.bitsPerEntry;
        if (bitsPerEntry == 0) {
            return;
        }
        IntOpenHashSet uniqueValues = new IntOpenHashSet();
        this.getAll((x, y, z, value) -> uniqueValues.add(value));
        int uniqueCount = uniqueValues.size();
        if (uniqueCount == 1) {
            this.fill(uniqueValues.iterator().nextInt());
            return;
        }
        if (focus == Palette.Optimization.SPEED) {
            this.makeDirect();
        } else if (focus == Palette.Optimization.SIZE) {
            IntArrayList paletteList = new IntArrayList(uniqueValues);
            this.downsizeWithPalette(paletteList);
        }
    }

    @Override
    public boolean compare(Palette p) {
        PaletteImpl palette = (PaletteImpl)p;
        int dimension = this.dimension();
        if (palette.dimension() != dimension) {
            return false;
        }
        if (palette.count != this.count) {
            return false;
        }
        if (palette.count == 0) {
            return true;
        }
        if (palette.bitsPerEntry == 0 && this.bitsPerEntry == 0) {
            return true;
        }
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value2;
                    int value1 = this.get(x, y, z);
                    if (value1 == (value2 = palette.get(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Palette clone() {
        PaletteImpl clone = new PaletteImpl(this.dimension, this.minBitsPerEntry, this.maxBitsPerEntry, this.directBits);
        clone.bitsPerEntry = this.bitsPerEntry;
        clone.count = this.count;
        if (this.bitsPerEntry == 0) {
            return clone;
        }
        clone.values = (long[])this.values.clone();
        if (this.paletteToValueList != null) {
            clone.paletteToValueList = this.paletteToValueList.clone();
        }
        if (this.valueToPaletteMap != null) {
            clone.valueToPaletteMap = this.valueToPaletteMap.clone();
        }
        return clone;
    }

    private void retrieveAll(Palette.EntryConsumer consumer, boolean consumeEmpty) {
        if (!consumeEmpty && this.count == 0) {
            return;
        }
        long[] values = this.values;
        int dimension = this.dimension();
        byte bitsPerEntry = this.bitsPerEntry;
        int magicMask = (1 << bitsPerEntry) - 1;
        int valuesPerLong = 64 / bitsPerEntry;
        int size = this.maxSize();
        int dimensionMinus = dimension - 1;
        int[] ids = this.hasPalette() ? this.paletteToValueList.elements() : null;
        int dimensionBitCount = MathUtils.bitsToRepresent(dimensionMinus);
        int shiftedDimensionBitCount = dimensionBitCount << 1;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                int paletteIndex = (int)(value >> bitIndex & (long)magicMask);
                if (!consumeEmpty && paletteIndex == 0) continue;
                int y = index >> shiftedDimensionBitCount;
                int z = index >> dimensionBitCount & dimensionMinus;
                int x = index & dimensionMinus;
                int result = ids != null && paletteIndex < ids.length ? ids[paletteIndex] : paletteIndex;
                consumer.accept(x, y, z, result);
            }
        }
    }

    private void updateAll(int[] paletteValues) {
        int size = this.maxSize();
        assert (paletteValues.length >= size);
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        long clear = (1L << bitsPerEntry) - 1L;
        long[] values = this.values;
        for (int i = 0; i < values.length; ++i) {
            long block = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                block = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)paletteValues[index] << bitIndex;
            }
            values[i] = block;
        }
    }

    private void downsizeWithPalette(IntArrayList palette) {
        byte bpe = this.bitsPerEntry;
        byte newBpe = (byte)Math.max(MathUtils.bitsToRepresent(palette.size() - 1), this.minBitsPerEntry);
        if (newBpe >= bpe || newBpe > this.maxBitsPerEntry) {
            return;
        }
        Int2IntOpenHashMap newValueToPaletteMap = new Int2IntOpenHashMap(palette.size());
        newValueToPaletteMap.defaultReturnValue(-1);
        AtomicInteger index = new AtomicInteger();
        palette.forEach(v -> {
            int plainIndex = index.getPlain();
            newValueToPaletteMap.put(v, plainIndex);
            index.setPlain(plainIndex + 1);
        });
        if (!this.hasPalette()) {
            this.values = Palettes.remap(this.dimension, bpe, newBpe, this.values, newValueToPaletteMap::get);
        } else {
            IntArrayList transformList = new IntArrayList(this.paletteToValueList.size());
            this.paletteToValueList.forEach(value -> transformList.add(newValueToPaletteMap.get(value)));
            int[] transformArray = transformList.elements();
            this.values = Palettes.remap(this.dimension, bpe, newBpe, this.values, value -> transformArray[value]);
        }
        this.bitsPerEntry = newBpe;
        this.valueToPaletteMap = newValueToPaletteMap;
        this.paletteToValueList = palette;
    }

    void makeDirect() {
        if (!this.hasPalette()) {
            return;
        }
        if (this.bitsPerEntry == 0) {
            int fillValue = this.count;
            this.values = new long[Palettes.arrayLength(this.dimension, this.directBits)];
            if (fillValue != 0) {
                Palettes.fill(this.directBits, this.values, fillValue);
                this.count = this.maxSize();
            }
        } else {
            int[] ids = this.paletteToValueList.elements();
            this.values = Palettes.remap(this.dimension, this.bitsPerEntry, this.directBits, this.values, v -> ids[v]);
        }
        this.paletteToValueList = null;
        this.valueToPaletteMap = null;
        this.bitsPerEntry = this.directBits;
    }

    void upsize() {
        byte bpe = this.bitsPerEntry;
        byte newBpe = (byte)(bpe + 1);
        if (newBpe > this.maxBitsPerEntry) {
            this.makeDirect();
        } else {
            this.values = Palettes.remap(this.dimension, bpe, newBpe, this.values, v -> v);
            this.bitsPerEntry = newBpe;
        }
    }

    void initIndirect() {
        int fillValue = this.count;
        this.valueToPaletteMap = new Int2IntOpenHashMap();
        this.valueToPaletteMap.defaultReturnValue(-1);
        this.paletteToValueList = new IntArrayList();
        this.valueToPaletteMap.put(fillValue, 0);
        this.paletteToValueList.add(fillValue);
        this.bitsPerEntry = this.minBitsPerEntry;
        this.values = new long[Palettes.arrayLength(this.dimension, this.minBitsPerEntry)];
        this.count = fillValue == 0 ? 0 : this.maxSize();
    }

    @Override
    public int paletteIndexToValue(int value) {
        return this.hasPalette() ? this.paletteToValueList.elements()[value] : value;
    }

    @Override
    public int valueToPaletteIndex(int value) {
        int lastPaletteIndex;
        int lookup;
        if (!this.hasPalette()) {
            return value;
        }
        if (this.values == null) {
            this.initIndirect();
        }
        if ((lookup = this.valueToPaletteMap.putIfAbsent(value, lastPaletteIndex = this.paletteToValueList.size())) != -1) {
            return lookup;
        }
        if (lastPaletteIndex >= Palettes.maxPaletteSize(this.bitsPerEntry)) {
            this.upsize();
            if (!this.hasPalette()) {
                return value;
            }
        }
        this.paletteToValueList.add(value);
        return lastPaletteIndex;
    }

    int valueToPalettIndexOrDefault(int value) {
        return this.hasPalette() ? this.valueToPaletteMap.get(value) : value;
    }

    @Override
    public int singleValue() {
        return this.bitsPerEntry == 0 ? this.count : -1;
    }

    @Override
    public long @Nullable [] indexedValues() {
        return this.values;
    }

    boolean hasPalette() {
        return this.bitsPerEntry <= this.maxBitsPerEntry;
    }

    private static void validateCoord(int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            throw new IllegalArgumentException("Coordinates must be non-negative");
        }
        if (x >= dimension || y >= dimension || z >= dimension) {
            throw new IllegalArgumentException("Coordinates must be less than the dimension size, got " + x + ", " + y + ", " + z + " for dimension " + dimension);
        }
    }

    private static void validateDimension(int dimension) {
        if (dimension <= 1 || (dimension & dimension - 1) != 0) {
            throw new IllegalArgumentException("Dimension must be a positive power of 2, got " + dimension);
        }
    }
}

