/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.Map;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.EntityEquipmentPacket;
import net.minestom.server.utils.validate.Check;

public interface EquipmentHandler {
    public ItemStack getEquipment(EquipmentSlot var1);

    public void setEquipment(EquipmentSlot var1, ItemStack var2);

    default public ItemStack getItemInMainHand() {
        return this.getEquipment(EquipmentSlot.MAIN_HAND);
    }

    default public void setItemInMainHand(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.MAIN_HAND, itemStack);
    }

    default public ItemStack getItemInOffHand() {
        return this.getEquipment(EquipmentSlot.OFF_HAND);
    }

    default public void setItemInOffHand(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.OFF_HAND, itemStack);
    }

    default public ItemStack getItemInHand(PlayerHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case PlayerHand.MAIN -> this.getItemInMainHand();
            case PlayerHand.OFF -> this.getItemInOffHand();
        };
    }

    default public void setItemInHand(PlayerHand hand, ItemStack stack) {
        switch (hand) {
            case MAIN: {
                this.setItemInMainHand(stack);
                break;
            }
            case OFF: {
                this.setItemInOffHand(stack);
            }
        }
    }

    default public ItemStack getHelmet() {
        return this.getEquipment(EquipmentSlot.HELMET);
    }

    default public void setHelmet(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.HELMET, itemStack);
    }

    default public ItemStack getChestplate() {
        return this.getEquipment(EquipmentSlot.CHESTPLATE);
    }

    default public void setChestplate(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.CHESTPLATE, itemStack);
    }

    default public ItemStack getLeggings() {
        return this.getEquipment(EquipmentSlot.LEGGINGS);
    }

    default public void setLeggings(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.LEGGINGS, itemStack);
    }

    default public ItemStack getBoots() {
        return this.getEquipment(EquipmentSlot.BOOTS);
    }

    default public void setBoots(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.BOOTS, itemStack);
    }

    default public ItemStack getBodyEquipment() {
        return this.getEquipment(EquipmentSlot.BODY);
    }

    default public void setBodyEquipment(ItemStack itemStack) {
        this.setEquipment(EquipmentSlot.BODY, itemStack);
    }

    default public boolean hasEquipment(EquipmentSlot slot) {
        return !this.getEquipment(slot).isAir();
    }

    default public void syncEquipment(EquipmentSlot slot) {
        this.syncEquipment(slot, this.getEquipment(slot));
    }

    default public void syncEquipment(EquipmentSlot slot, ItemStack stack) {
        Check.stateCondition(!(this instanceof Entity), "Only accessible for Entity");
        Entity entity = (Entity)((Object)this);
        entity.sendPacketToViewers(new EntityEquipmentPacket(entity.getEntityId(), Map.of(slot, stack)));
    }

    default public EntityEquipmentPacket getEquipmentsPacket() {
        Check.stateCondition(!(this instanceof Entity), "Only accessible for Entity");
        return new EntityEquipmentPacket(((Entity)((Object)this)).getEntityId(), Map.of(EquipmentSlot.MAIN_HAND, this.getItemInMainHand(), EquipmentSlot.OFF_HAND, this.getItemInOffHand(), EquipmentSlot.BOOTS, this.getBoots(), EquipmentSlot.LEGGINGS, this.getLeggings(), EquipmentSlot.CHESTPLATE, this.getChestplate(), EquipmentSlot.HELMET, this.getHelmet(), EquipmentSlot.BODY, this.getBodyEquipment()));
    }
}

