/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.List;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.SetCursorItemPacket;
import net.minestom.server.network.packet.server.play.SetPlayerInventorySlotPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Nullable;

public non-sealed class PlayerInventory
extends AbstractInventory {
    public static final int INVENTORY_SIZE = 46;
    public static final int INNER_INVENTORY_SIZE = 36;
    private ItemStack cursorItem = ItemStack.AIR;

    public PlayerInventory() {
        super(46);
    }

    @Override
    public synchronized void clear() {
        this.cursorItem = ItemStack.AIR;
        super.clear();
        this.viewers.forEach(viewer -> viewer.sendPacketToViewersAndSelf(viewer.getEquipmentsPacket()));
    }

    @Override
    public int getInnerSize() {
        return 36;
    }

    @Override
    public byte getWindowId() {
        return 0;
    }

    private int getSlotId(EquipmentSlot slot, byte heldSlot) {
        return switch (slot) {
            case EquipmentSlot.MAIN_HAND -> heldSlot;
            case EquipmentSlot.OFF_HAND -> 45;
            default -> slot.armorSlot();
        };
    }

    @Nullable
    private EquipmentSlot getEquipmentSlot(int slot, byte heldSlot) {
        return switch (slot) {
            case 45 -> EquipmentSlot.OFF_HAND;
            case 41 -> EquipmentSlot.HELMET;
            case 42 -> EquipmentSlot.CHESTPLATE;
            case 43 -> EquipmentSlot.LEGGINGS;
            case 44 -> EquipmentSlot.BOOTS;
            default -> slot == heldSlot ? EquipmentSlot.MAIN_HAND : null;
        };
    }

    public ItemStack getEquipment(EquipmentSlot slot, byte heldSlot) {
        int slotId = this.getSlotId(slot, heldSlot);
        if (slotId < 0) {
            return ItemStack.AIR;
        }
        return this.getItemStack(slotId);
    }

    public void setEquipment(EquipmentSlot slot, byte heldSlot, ItemStack itemStack) {
        int slotId = this.getSlotId(slot, heldSlot);
        if (slotId < 0) {
            Check.fail("PlayerInventory does not support " + String.valueOf((Object)slot) + " equipment");
        }
        this.setItemStack(slotId, itemStack);
    }

    @Override
    public void update(Player player) {
        player.sendPacket(this.createWindowItemsPacket());
    }

    public ItemStack getCursorItem() {
        return this.cursorItem;
    }

    public void setCursorItem(ItemStack cursorItem) {
        this.setCursorItem(cursorItem, true);
    }

    public void setCursorItem(ItemStack cursorItem, boolean sendPacket) {
        if (this.cursorItem.equals(cursorItem)) {
            return;
        }
        this.cursorItem = cursorItem;
        if (sendPacket) {
            this.sendPacketToViewers(new SetCursorItemPacket(cursorItem));
        }
    }

    @Override
    protected void UNSAFE_itemInsert(int slot, ItemStack item, ItemStack previous, boolean sendPacket) {
        for (Player player : this.getViewers()) {
            EquipmentSlot equipmentSlot = this.getEquipmentSlot(slot, player.getHeldSlot());
            if (equipmentSlot == null) continue;
            EntityEquipEvent entityEquipEvent = new EntityEquipEvent(player, item, equipmentSlot);
            EventDispatcher.call(entityEquipEvent);
            item = entityEquipEvent.getEquippedItem();
            player.updateEquipmentAttributes(previous, item, equipmentSlot);
            player.syncEquipment(equipmentSlot, item);
        }
        super.UNSAFE_itemInsert(slot, item, previous, sendPacket);
    }

    @Override
    public void sendSlotRefresh(int slot, ItemStack item) {
        if (slot < 0 || slot > 46) {
            return;
        }
        boolean isPlayerInventorySlot = PlayerInventoryUtils.isPlayerInventorySlot(slot);
        int packetSlot = isPlayerInventorySlot ? PlayerInventoryUtils.convertMinestomSlotToPlayerInventorySlot(slot) : PlayerInventoryUtils.convertMinestomSlotToWindowSlot(slot);
        this.sendPacketToViewers((SendablePacket)((Object)(isPlayerInventorySlot ? new SetPlayerInventorySlotPacket(packetSlot, item) : new SetSlotPacket(0, 0, (short)packetSlot, item))));
    }

    private WindowItemsPacket createWindowItemsPacket() {
        ItemStack[] convertedSlots = new ItemStack[46];
        for (int i = 0; i < this.itemStacks.length; ++i) {
            int slot = PlayerInventoryUtils.convertMinestomSlotToWindowSlot(i);
            convertedSlots[slot] = this.itemStacks[i];
        }
        return new WindowItemsPacket(0, 0, List.of(convertedSlots), this.cursorItem);
    }

    @Override
    public boolean leftClick(Player player, int slot) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(slot);
        InventoryClickResult clickResult = this.clickProcessor.leftClick(clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(slot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, this, slot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(Player player, int slot) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(slot);
        InventoryClickResult clickResult = this.clickProcessor.rightClick(clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(slot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, this, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean middleClick(Player player, int slot) {
        this.update();
        return false;
    }

    @Override
    public boolean drop(Player player, boolean all, int slot) {
        ItemStack cursor;
        boolean outsideDrop = slot == -999;
        ItemStack clicked = outsideDrop ? ItemStack.AIR : this.getItemStack(slot);
        InventoryClickResult clickResult = this.clickProcessor.drop(player, all, slot, clicked, cursor = this.getCursorItem());
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (resultClicked != null && !outsideDrop) {
            this.setItemStack(slot, resultClicked);
        }
        this.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean shiftClick(Player player, int slot, int button) {
        InventoryClickResult clickResult;
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(slot);
        boolean craftingGridClick = slot > 36 && slot <= 40;
        boolean craftingResultClick = slot == 36;
        boolean hotBarClick = slot < 9;
        EquipmentSlot equipmentSlot = this.getEquipmentSlot(slot, player.getHeldSlot());
        if (equipmentSlot != null && (equipmentSlot.isArmor() || equipmentSlot == EquipmentSlot.OFF_HAND)) {
            clickResult = this.clickProcessor.shiftClick(this, this, 9, 36, 1, player, slot, clicked, cursor);
            if (clickResult.isCancel()) {
                clickResult = this.clickProcessor.shiftClick(this, this, 0, 9, 1, player, slot, clicked, cursor);
            }
        } else if (craftingGridClick) {
            clickResult = this.clickProcessor.shiftClick(this, this, 9, 36, 1, player, slot, clicked, cursor);
            if (clickResult.isCancel()) {
                clickResult = this.clickProcessor.shiftClick(this, this, 0, 9, 1, player, slot, clicked, cursor);
            }
        } else if (craftingResultClick) {
            clickResult = this.clickProcessor.shiftClick(this, this, 9, 0, -1, player, slot, clicked, cursor);
            if (clickResult.isCancel()) {
                clickResult = this.clickProcessor.shiftClick(this, this, 36, 9, -1, player, slot, clicked, cursor);
            }
        } else {
            clickResult = this.clickProcessor.shiftClick(this, this, hotBarClick ? 9 : 0, hotBarClick ? 36 : 9, 1, player, slot, clicked, cursor);
        }
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(slot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    @Override
    public boolean changeHeld(Player player, int slot, int key) {
        ItemStack cursorItem = this.getCursorItem();
        if (!cursorItem.isAir()) {
            return false;
        }
        ItemStack heldItem = this.getItemStack(key);
        ItemStack clicked = this.getItemStack(slot);
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(clicked, heldItem);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(slot, clickResult.getClicked());
        this.setItemStack(key, clickResult.getCursor());
        this.callClickEvent(player, this, slot, ClickType.CHANGE_HELD, clicked, cursorItem);
        return true;
    }

    @Override
    public boolean dragging(Player player, List<Integer> slots, int button) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clickResult = this.clickProcessor.dragging(player, this, slots, button, cursor);
        if (clickResult == null) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult);
        this.update();
        return true;
    }

    @Override
    public boolean doubleClick(Player player, int slot) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(slot);
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(this, this, player, slot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }
}

