/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.MathUtils;

@FunctionalInterface
public interface TransactionType {
    public static final TransactionType ADD = (inventory, itemStack, slotPredicate, start, end, step) -> {
        ItemStack inventoryItem;
        Int2ObjectOpenHashMap<ItemStack> itemChangesMap = new Int2ObjectOpenHashMap<ItemStack>();
        int i = start;
        while (step > 0 ? i < end : i > end) {
            int maxSize;
            int itemAmount;
            inventoryItem = inventory.getItemStack(i);
            if (!inventoryItem.isAir() && itemStack.isSimilar(inventoryItem) && (itemAmount = inventoryItem.amount()) < (maxSize = inventoryItem.maxStackSize()) && slotPredicate.test(i, inventoryItem)) {
                int itemStackAmount = itemStack.amount();
                int totalAmount = itemStackAmount + itemAmount;
                if (!MathUtils.isBetween(totalAmount, 0, itemStack.maxStackSize())) {
                    itemChangesMap.put(i, inventoryItem.withAmount(maxSize));
                    itemStack = itemStack.withAmount(totalAmount - maxSize);
                } else {
                    itemChangesMap.put(i, inventoryItem.withAmount(totalAmount));
                    itemStack = ItemStack.AIR;
                    break;
                }
            }
            i += step;
        }
        i = start;
        while (step > 0 ? i < end : i > end) {
            inventoryItem = inventory.getItemStack(i);
            if (inventoryItem.isAir() && slotPredicate.test(i, inventoryItem)) {
                int maxSize = itemStack.maxStackSize();
                int currentSize = itemStack.amount();
                if (!MathUtils.isBetween(currentSize, 0, maxSize)) {
                    itemChangesMap.put(i, itemStack.withAmount(maxSize));
                    itemStack = itemStack.withAmount(currentSize - maxSize);
                } else {
                    itemChangesMap.put(i, itemStack.withAmount(currentSize));
                    itemStack = ItemStack.AIR;
                    break;
                }
            }
            i += step;
        }
        return Pair.of(itemStack, itemChangesMap);
    };
    public static final TransactionType TAKE = (inventory, itemStack, slotPredicate, start, end, step) -> {
        Int2ObjectOpenHashMap<ItemStack> itemChangesMap = new Int2ObjectOpenHashMap<ItemStack>();
        int i = start;
        while (step > 0 ? i < end : i > end) {
            ItemStack inventoryItem = inventory.getItemStack(i);
            if (!inventoryItem.isAir() && itemStack.isSimilar(inventoryItem) && slotPredicate.test(i, inventoryItem)) {
                int itemAmount = inventoryItem.amount();
                int itemStackAmount = itemStack.amount();
                if (itemStackAmount < itemAmount) {
                    itemChangesMap.put(i, inventoryItem.withAmount(itemAmount - itemStackAmount));
                    itemStack = ItemStack.AIR;
                    break;
                }
                itemChangesMap.put(i, ItemStack.AIR);
                itemStack = itemStack.withAmount(itemStackAmount - itemAmount);
                if (itemStack.amount() == 0) {
                    itemStack = ItemStack.AIR;
                    break;
                }
            }
            i += step;
        }
        return Pair.of(itemStack, itemChangesMap);
    };

    public Pair<ItemStack, Map<Integer, ItemStack>> process(AbstractInventory var1, ItemStack var2, SlotPredicate var3, int var4, int var5, int var6);

    default public Pair<ItemStack, Map<Integer, ItemStack>> process(AbstractInventory inventory, ItemStack itemStack, SlotPredicate slotPredicate) {
        return this.process(inventory, itemStack, slotPredicate, 0, inventory.getInnerSize(), 1);
    }

    default public Pair<ItemStack, Map<Integer, ItemStack>> process(AbstractInventory inventory, ItemStack itemStack) {
        return this.process(inventory, itemStack, (slot, itemStack1) -> true);
    }

    @FunctionalInterface
    public static interface SlotPredicate {
        public boolean test(int var1, ItemStack var2);
    }
}

