/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.play.TradeListPacket;

public class VillagerInventory
extends Inventory {
    private final CachedPacket tradeCache = new CachedPacket(this::createTradePacket);
    private final List<TradeListPacket.Trade> trades = new ArrayList<TradeListPacket.Trade>();
    private int villagerLevel;
    private int experience;
    private boolean regularVillager;
    private boolean canRestock;

    public VillagerInventory(Component title) {
        super(InventoryType.MERCHANT, title);
    }

    public VillagerInventory(String title) {
        super(InventoryType.MERCHANT, title);
    }

    public List<TradeListPacket.Trade> getTrades() {
        return Collections.unmodifiableList(this.trades);
    }

    public void addTrade(TradeListPacket.Trade trade) {
        this.trades.add(trade);
        this.update();
    }

    public void removeTrade(int index) {
        this.trades.remove(index);
        this.update();
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public void setVillagerLevel(int level) {
        this.villagerLevel = level;
        this.update();
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.update();
    }

    public boolean isRegularVillager() {
        return this.regularVillager;
    }

    public void setRegularVillager(boolean regularVillager) {
        this.regularVillager = regularVillager;
        this.update();
    }

    public boolean canRestock() {
        return this.canRestock;
    }

    public void setCanRestock(boolean canRestock) {
        this.canRestock = canRestock;
        this.update();
    }

    @Override
    public void update() {
        super.update();
        this.tradeCache.invalidate();
        this.sendPacketToViewers(this.tradeCache);
    }

    @Override
    public boolean addViewer(Player player) {
        boolean result = super.addViewer(player);
        if (result) {
            player.sendPacket(this.tradeCache);
        }
        return result;
    }

    private TradeListPacket createTradePacket() {
        return new TradeListPacket(this.getWindowId(), this.trades, this.villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }
}

