/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.item.component.TooltipDisplay;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

record ItemStackImpl(Material material, int amount, DataComponentMap components) implements ItemStack
{
    public ItemStackImpl {
        Check.notNull(material, "Material cannot be null");
        if (components != DataComponentMap.EMPTY) {
            components = DataComponentMap.diff(material.prototype(), components);
        }
    }

    static NetworkBuffer.Type<ItemStack> networkType(final NetworkBuffer.Type<DataComponentMap> componentPatchType) {
        return new NetworkBuffer.Type<ItemStack>(){

            @Override
            public void write(NetworkBuffer buffer, ItemStack value) {
                if (value.isAir()) {
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    return;
                }
                buffer.write(NetworkBuffer.VAR_INT, value.amount());
                buffer.write(NetworkBuffer.VAR_INT, value.material().id());
                buffer.write(componentPatchType, ((ItemStackImpl)value).components());
            }

            @Override
            public ItemStack read(NetworkBuffer buffer) {
                int amount = buffer.read(NetworkBuffer.VAR_INT);
                if (amount <= 0) {
                    return ItemStack.AIR;
                }
                Material material = Material.fromId(buffer.read(NetworkBuffer.VAR_INT));
                DataComponentMap components = (DataComponentMap)buffer.read(componentPatchType);
                return ItemStackImpl.create(material, amount, components);
            }
        };
    }

    static ItemStack create(Material material, int amount, DataComponentMap components) {
        if (amount <= 0 || material == Material.AIR) {
            return AIR;
        }
        return new ItemStackImpl(material, amount, components);
    }

    static ItemStack create(Material material, int amount) {
        return ItemStackImpl.create(material, amount, DataComponentMap.EMPTY);
    }

    @Override
    public DataComponentMap componentPatch() {
        return this.components;
    }

    @Override
    @Nullable
    public <T> T get(DataComponent<T> component) {
        return this.components.get(this.material.prototype(), component);
    }

    @Override
    public boolean has(DataComponent<?> component) {
        return this.components.has(this.material.prototype(), component);
    }

    @Override
    public ItemStack with(Consumer<ItemStack.Builder> consumer) {
        ItemStack.Builder builder = this.builder();
        consumer.accept(builder);
        return builder.build();
    }

    @Override
    public ItemStack withMaterial(Material material) {
        return new ItemStackImpl(material, this.amount, this.components);
    }

    @Override
    public ItemStack withAmount(int amount) {
        if (amount <= 0) {
            return ItemStack.AIR;
        }
        return ItemStackImpl.create(this.material, amount, this.components);
    }

    @Override
    public <T> ItemStack with(DataComponent<T> component, T value) {
        return new ItemStackImpl(this.material, this.amount, this.components.set(component, value));
    }

    @Override
    public ItemStack without(DataComponent<?> component) {
        if (this.get(component) == null) {
            return this;
        }
        return new ItemStackImpl(this.material, this.amount, this.components.remove(component));
    }

    @Override
    public ItemStack consume(int amount) {
        return this.withAmount(this.amount() - amount);
    }

    @Override
    public ItemStack damage(int amount) {
        Integer damage = this.get(DataComponents.DAMAGE);
        if (damage == null) {
            return this;
        }
        Integer maxDamage = this.get(DataComponents.MAX_DAMAGE);
        if (maxDamage != null && damage + amount >= maxDamage) {
            return ItemStack.AIR;
        }
        return this.with(DataComponents.DAMAGE, damage + amount);
    }

    @Override
    public boolean isSimilar(ItemStack itemStack) {
        return this.material == itemStack.material() && this.components.equals(((ItemStackImpl)itemStack).components);
    }

    @Override
    public CompoundBinaryTag toItemNBT() {
        RegistryTranscoder<BinaryTag> coder = new RegistryTranscoder<BinaryTag>(Transcoder.NBT, MinecraftServer.process());
        return (CompoundBinaryTag)CODEC.encode(coder, this).orElseThrow("Invalid NBT for ItemStack");
    }

    @Override
    @Contract(value="-> new", pure=true)
    public ItemStack.Builder builder() {
        return new Builder(this.material, this.amount, this.components.toPatchBuilder());
    }

    static final class Builder
    implements ItemStack.Builder {
        private Material material;
        private int amount;
        private DataComponentMap.PatchBuilder components;

        Builder(Material material, int amount, DataComponentMap.PatchBuilder components) {
            this.material = material;
            this.amount = amount;
            this.components = components;
        }

        Builder(Material material, int amount) {
            this.material = material;
            this.amount = amount;
            this.components = DataComponentMap.patchBuilder();
        }

        @Override
        public ItemStack.Builder material(Material material) {
            this.material = material;
            return this;
        }

        @Override
        public ItemStack.Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public <T> ItemStack.Builder set(DataComponent<T> component, T value) {
            this.components.set(component, value);
            return this;
        }

        @Override
        public ItemStack.Builder remove(DataComponent<?> component) {
            this.components.remove(component);
            return this;
        }

        @Override
        public <T> ItemStack.Builder set(Tag<T> tag, @Nullable T value) {
            this.components.set(DataComponents.CUSTOM_DATA, this.components.get(DataComponents.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
            return this;
        }

        @Override
        public ItemStack.Builder hideExtraTooltip() {
            return this.set(DataComponents.TOOLTIP_DISPLAY, new TooltipDisplay(false, Set.of(DataComponents.BANNER_PATTERNS, DataComponents.BEES, DataComponents.BLOCK_ENTITY_DATA, DataComponents.BLOCK_STATE, DataComponents.BUNDLE_CONTENTS, DataComponents.CHARGED_PROJECTILES, DataComponents.CONTAINER, DataComponents.CONTAINER_LOOT, DataComponents.FIREWORK_EXPLOSION, DataComponents.FIREWORKS, DataComponents.INSTRUMENT, DataComponents.MAP_ID, DataComponents.PAINTING_VARIANT, DataComponents.POT_DECORATIONS, DataComponents.POTION_CONTENTS, DataComponents.TROPICAL_FISH_PATTERN, DataComponents.WRITTEN_BOOK_CONTENT, DataComponents.UNBREAKABLE, DataComponents.ATTRIBUTE_MODIFIERS)));
        }

        @Override
        public ItemStack build() {
            return ItemStackImpl.create(this.material, this.amount, this.components.build());
        }
    }
}

