/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.MinecraftServer;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.PlayerBeginItemUseEvent;
import net.minestom.server.event.player.PlayerUseItemEvent;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemAnimation;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.Consumable;
import net.minestom.server.item.component.Equippable;
import net.minestom.server.item.component.InstrumentComponent;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.listener.PlayerPositionListener;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.server.play.AcknowledgeBlockChangePacket;

public class UseItemListener {
    public static void useItemListener(ClientUseItemPacket packet, Player player) {
        PlayerPositionListener.playerRotation(player, packet.yaw(), packet.pitch());
        PlayerHand hand = packet.hand();
        ItemStack itemStack = player.getItemInHand(hand);
        Material material = itemStack.material();
        Consumable consumable = itemStack.get(DataComponents.CONSUMABLE);
        long useItemTime = 0L;
        ItemAnimation useAnimation = ItemAnimation.NONE;
        if (material == Material.BOW) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.BOW;
        } else if (material == Material.CROSSBOW) {
            useItemTime = 7200L;
            useAnimation = ItemAnimation.CROSSBOW;
        } else if (itemStack.has(DataComponents.BLOCKS_ATTACKS)) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.BLOCK;
        } else if (material == Material.TRIDENT) {
            useItemTime = 72000L;
            useAnimation = ItemAnimation.SPEAR;
        } else if (material == Material.SPYGLASS) {
            useItemTime = 1200L;
            useAnimation = ItemAnimation.SPYGLASS;
        } else if (material == Material.GOAT_HORN) {
            useItemTime = UseItemListener.getInstrumentTime(itemStack);
            useAnimation = ItemAnimation.TOOT_HORN;
        } else if (material == Material.BRUSH) {
            useItemTime = 200L;
            useAnimation = ItemAnimation.BRUSH;
        } else if (material.name().contains("bundle")) {
            useItemTime = 200L;
            useAnimation = ItemAnimation.BUNDLE;
        } else if (consumable != null) {
            useItemTime = consumable.consumeTicks();
            useAnimation = consumable.animation();
        }
        boolean usingMainHand = player.getItemUseHand() == PlayerHand.MAIN && hand == PlayerHand.OFF;
        PlayerUseItemEvent useItemEvent = new PlayerUseItemEvent(player, hand, itemStack, usingMainHand ? 0L : useItemTime);
        EventDispatcher.call(useItemEvent);
        player.sendPacket(new AcknowledgeBlockChangePacket(packet.sequence()));
        PlayerInventory playerInventory = player.getInventory();
        if (useItemEvent.isCancelled()) {
            playerInventory.update();
            return;
        }
        useItemTime = useItemEvent.getItemUseTime();
        if (useItemTime != 0L) {
            PlayerBeginItemUseEvent beginUseEvent = new PlayerBeginItemUseEvent(player, hand, itemStack, useAnimation, useItemTime);
            EventDispatcher.callCancellable(beginUseEvent, () -> {
                if (beginUseEvent.getItemUseDuration() <= 0L) {
                    return;
                }
                player.refreshItemUse(hand, beginUseEvent.getItemUseDuration());
                player.refreshActiveHand(true, hand == PlayerHand.OFF, false);
            });
            return;
        }
        Equippable equippable = itemStack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.swappable() && equippable.slot().armorSlot() > 0) {
            ItemStack currentlyEquipped = player.getEquipment(equippable.slot());
            player.setEquipment(equippable.slot(), itemStack);
            player.setItemInHand(hand, currentlyEquipped);
        }
    }

    private static int getInstrumentTime(ItemStack itemStack) {
        InstrumentComponent holder = itemStack.get(DataComponents.INSTRUMENT);
        if (holder == null) {
            return 0;
        }
        Instrument instrument = holder.resolve(MinecraftServer.getInstrumentRegistry());
        if (instrument == null) {
            return 0;
        }
        return instrument.useDurationTicks();
    }
}

