/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.server.play.SetCursorItemPacket;
import org.jetbrains.annotations.Nullable;

public class WindowListener {
    public static void clickWindowListener(ClientClickWindowPacket packet, Player player) {
        ItemStack cursorItem;
        AbstractInventory inventory;
        int windowId = packet.windowId();
        boolean playerInventory = windowId == 0;
        AbstractInventory abstractInventory = inventory = playerInventory ? player.getInventory() : player.getOpenInventory();
        if (inventory == null || packet.slot() == -1) {
            return;
        }
        @Nullable Integer size = playerInventory ? null : Integer.valueOf(inventory.getSize());
        Click click = player.getClickPreprocessor().processClick(packet, size);
        boolean successful = true;
        if (click != null) {
            boolean isNotCreative;
            boolean bl = isNotCreative = player.getGameMode() != GameMode.CREATIVE;
            if (isNotCreative && player.getClickPreprocessor().isCreativeClick(click, !player.getInventory().getCursorItem().isAir())) {
                successful = false;
            } else {
                player.UNSAFE_changeDidCloseInventory(false);
                Click.Window window = Click.toWindow(click, size);
                InventoryPreClickEvent inventoryPreClickEvent = new InventoryPreClickEvent(window.inOpened() ? inventory : player.getInventory(), player, window.click());
                EventDispatcher.call(inventoryPreClickEvent);
                click = Click.fromWindow(new Click.Window(window.inOpened(), inventoryPreClickEvent.getClick()), size);
                if (player.didCloseInventory()) {
                    player.UNSAFE_changeDidCloseInventory(false);
                    successful = false;
                } else {
                    successful = inventoryPreClickEvent.isCancelled() ? false : inventory.handleClick(player, click);
                }
            }
        }
        if (!successful) {
            player.getInventory().update(player);
            if (!playerInventory) {
                inventory.update(player);
            }
        }
        if (!ItemStack.Hash.of(cursorItem = player.getInventory().getCursorItem()).equals(packet.clickedItem())) {
            player.sendPacket(new SetCursorItemPacket(cursorItem));
        }
    }

    public static void pong(ClientPongPacket packet, Player player) {
    }

    public static void closeWindowListener(ClientCloseWindowPacket packet, Player player) {
        player.closeInventory(true, (byte)packet.windowId());
    }
}

