/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.preplay;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.Auth;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.configuration.ClientSelectKnownPacksPacket;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientConfigurationAckPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.network.plugin.LoginPlugin;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.utils.mojang.MojangUtils;

public final class LoginListener {
    private static final Component ALREADY_CONNECTED = Component.text("You are already on this server", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_DURING_LOGIN = Component.text("Error during login!", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_MALFORMED_USERNAME = Component.text("Error malformed username", (TextColor)NamedTextColor.RED);
    private static final Component ENCRYPTION_FAILED = Component.text("Encryption failed!", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_MOJANG_RESPONSE = Component.text("Failed to contact Mojang's Session Servers (Are they down?)", (TextColor)NamedTextColor.RED);
    public static final Component INVALID_PROXY_RESPONSE = Component.text("Invalid proxy response!", (TextColor)NamedTextColor.RED);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loginStartListener(ClientLoginStartPacket packet, PlayerConnection connection) {
        GameProfile gameProfile;
        Auth auth;
        block10: {
            auth = MinecraftServer.process().auth();
            boolean isSocketConnection = connection instanceof PlayerSocketConnection;
            if (isSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                socketConnection.UNSAFE_setLoginUsername(packet.username());
                if (auth instanceof Auth.Velocity) {
                    connection.loginPluginMessageProcessor().request("velocity:player_info", new byte[0]).thenAccept(response -> LoginListener.handleVelocityProxyResponse(socketConnection, response));
                    return;
                }
            }
            if (auth instanceof Auth.Online) {
                KeyPair keyPair;
                Auth.Online online = (Auth.Online)auth;
                try {
                    KeyPair keyPair2;
                    keyPair = keyPair2 = online.keyPair();
                    if (!isSocketConnection) break block10;
                    if (MinecraftServer.getConnectionManager().getOnlinePlayerByUsername(packet.username()) != null) {
                        connection.kick(ALREADY_CONNECTED);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                byte[] publicKey = keyPair.getPublic().getEncoded();
                byte[] nonce = new byte[4];
                ThreadLocalRandom.current().nextBytes(nonce);
                socketConnection.setNonce(nonce);
                socketConnection.sendPacket(new EncryptionRequestPacket("", publicKey, nonce, true));
                return;
            }
        }
        if (auth instanceof Auth.Bungee) {
            assert (connection instanceof PlayerSocketConnection);
            GameProfile bungeeProfile = ((PlayerSocketConnection)connection).gameProfile();
            assert (bungeeProfile != null);
            gameProfile = new GameProfile(bungeeProfile.uuid(), packet.username(), bungeeProfile.properties());
        } else {
            gameProfile = new GameProfile(packet.profileId(), packet.username());
        }
        LoginListener.enterConfig(connection, gameProfile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loginEncryptionResponseListener(ClientEncryptionResponsePacket packet, PlayerConnection connection) {
        boolean verificationFailed;
        KeyPair keyPair;
        Auth auth = MinecraftServer.process().auth();
        if (!(auth instanceof Auth.Online)) {
            connection.kick(Component.text("Encryption is not supported in offline mode", (TextColor)NamedTextColor.RED));
            return;
        }
        Auth.Online online = (Auth.Online)auth;
        try {
            KeyPair keyPair2;
            keyPair = keyPair2 = online.keyPair();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(connection instanceof PlayerSocketConnection)) return;
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        String loginUsername = socketConnection.getLoginUsername();
        if (loginUsername == null || loginUsername.isEmpty()) {
            connection.kick(ERROR_MALFORMED_USERNAME);
            return;
        }
        boolean hasPublicKey = connection.playerPublicKey() != null;
        boolean bl = verificationFailed = hasPublicKey || !Arrays.equals(socketConnection.getNonce(), MojangCrypt.decryptUsingKey(keyPair.getPrivate(), packet.encryptedVerifyToken()));
        if (verificationFailed) {
            MinecraftServer.LOGGER.error("Encryption failed for {}", (Object)loginUsername);
            connection.kick(ENCRYPTION_FAILED);
            return;
        }
        SecretKey secretKey = MojangCrypt.decryptByteToSecretKey(keyPair.getPrivate(), packet.sharedSecret());
        byte[] digestedData = MojangCrypt.digestData("", keyPair.getPublic(), secretKey);
        if (digestedData == null) {
            MinecraftServer.LOGGER.error("Connection {} failed initializing encryption.", (Object)socketConnection.getRemoteAddress());
            connection.kick(ENCRYPTION_FAILED);
            return;
        }
        String serverId = new BigInteger(digestedData).toString(16);
        try {
            JsonObject gameProfileJson = MojangUtils.authenticateSession(loginUsername, serverId, socketConnection.getRemoteAddress());
            socketConnection.setEncryptionKey(secretKey);
            UUID profileUUID = UUID.fromString(gameProfileJson.get("id").getAsString().replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            String profileName = gameProfileJson.get("name").getAsString();
            MinecraftServer.LOGGER.info("UUID of player {} is {}", (Object)profileName, (Object)profileUUID);
            ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
            Iterator<JsonElement> iterator = gameProfileJson.get("properties").getAsJsonArray().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    LoginListener.enterConfig(connection, new GameProfile(profileUUID, profileName, propertyList));
                    return;
                }
                JsonElement element = iterator.next();
                JsonObject object = element.getAsJsonObject();
                propertyList.add(new GameProfile.Property(object.get("name").getAsString(), object.get("value").getAsString(), object.get("signature").getAsString()));
            }
        }
        catch (IOException e) {
            socketConnection.kick(ERROR_MOJANG_RESPONSE);
            MinecraftServer.getExceptionManager().handleException(e);
            return;
        }
        catch (Exception e) {
            socketConnection.kick(ERROR_DURING_LOGIN);
            MinecraftServer.getExceptionManager().handleException(e);
            return;
        }
    }

    private static void handleVelocityProxyResponse(PlayerSocketConnection socketConnection, LoginPlugin.Response response) {
        NetworkBuffer buffer;
        Auth auth = MinecraftServer.process().auth();
        if (!(auth instanceof Auth.Velocity)) {
            socketConnection.kick(Component.text("Login plugin response is not supported in this auth mode", (TextColor)NamedTextColor.RED));
            return;
        }
        Auth.Velocity velocity = (Auth.Velocity)auth;
        byte[] data = response.payload();
        InetSocketAddress socketAddress = null;
        GameProfile gameProfile = null;
        boolean success = false;
        if (data != null && data.length > 0 && (success = velocity.checkIntegrity(buffer = NetworkBuffer.wrap(data, 0, data.length)))) {
            InetAddress address;
            try {
                address = InetAddress.getByName(buffer.read(NetworkBuffer.STRING));
            }
            catch (UnknownHostException e) {
                socketConnection.kick(INVALID_PROXY_RESPONSE);
                MinecraftServer.getExceptionManager().handleException(e);
                return;
            }
            int port = ((InetSocketAddress)socketConnection.getRemoteAddress()).getPort();
            socketAddress = new InetSocketAddress(address, port);
            gameProfile = GameProfile.SERIALIZER.read(buffer);
        }
        if (!success) {
            socketConnection.kick(INVALID_PROXY_RESPONSE);
            return;
        }
        socketConnection.setRemoteAddress(socketAddress);
        LoginListener.enterConfig(socketConnection, gameProfile);
    }

    public static void loginPluginResponseListener(ClientLoginPluginResponsePacket packet, PlayerConnection connection) {
        try {
            LoginPluginMessageProcessor messageProcessor = connection.loginPluginMessageProcessor();
            messageProcessor.handleResponse(packet.messageId(), packet.data());
        }
        catch (Throwable t) {
            connection.kick(ERROR_DURING_LOGIN);
            MinecraftServer.LOGGER.error("Error handling Login Plugin Response", t);
            MinecraftServer.getExceptionManager().handleException(t);
        }
    }

    public static void loginAckListener(ClientLoginAcknowledgedPacket ignored, PlayerConnection connection) {
        if (!(connection instanceof PlayerSocketConnection)) {
            throw new UnsupportedOperationException("Only socket");
        }
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        GameProfile gameProfile = socketConnection.gameProfile();
        assert (gameProfile != null);
        try {
            Player player = MinecraftServer.getConnectionManager().createPlayer(connection, gameProfile);
            LoginListener.executeConfig(player, true);
        }
        catch (Throwable t) {
            MinecraftServer.getExceptionManager().handleException(t);
            connection.kick(ERROR_DURING_LOGIN);
        }
    }

    public static void configAckListener(ClientConfigurationAckPacket packet, Player player) {
        LoginListener.executeConfig(player, false);
    }

    public static void selectKnownPacks(ClientSelectKnownPacksPacket packet, Player player) {
        player.getPlayerConnection().receiveKnownPacksResponse(packet.entries());
    }

    public static void finishConfigListener(ClientFinishConfigurationPacket packet, Player player) {
        MinecraftServer.getConnectionManager().transitionConfigToPlay(player);
    }

    private static void enterConfig(PlayerConnection connection, GameProfile gameProfile) {
        Thread.startVirtualThread(() -> {
            try {
                GameProfile newGameProfile = MinecraftServer.getConnectionManager().transitionLoginToConfig(connection, gameProfile);
                if (connection instanceof PlayerSocketConnection) {
                    PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                    socketConnection.UNSAFE_setProfile(newGameProfile);
                }
            }
            catch (Throwable t) {
                MinecraftServer.getExceptionManager().handleException(t);
            }
        });
    }

    private static void executeConfig(Player player, boolean isFirstConfig) {
        Thread.startVirtualThread(() -> {
            try {
                MinecraftServer.getConnectionManager().doConfiguration(player, isFirstConfig);
            }
            catch (Throwable t) {
                MinecraftServer.getExceptionManager().handleException(t);
                player.kick(ERROR_DURING_LOGIN);
            }
        });
    }
}

