/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.message.ChatTypeDecoration;
import net.minestom.server.message.ChatTypeImpl;
import net.minestom.server.message.ChatTypes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;

public sealed interface ChatType
extends Holder.Direct<ChatType>,
ChatTypes
permits ChatTypeImpl {
    public static final Codec<ChatType> REGISTRY_CODEC = StructCodec.struct("chat", ChatTypeDecoration.CODEC, ChatType::chat, "narration", ChatTypeDecoration.CODEC, ChatType::narration, ChatType::create);

    public static ChatType create(ChatTypeDecoration chat, ChatTypeDecoration narration) {
        return new ChatTypeImpl(chat, narration);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<ChatType> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("chat_type"), REGISTRY_CODEC, RegistryData.Resource.CHAT_TYPES);
    }

    public ChatTypeDecoration chat();

    public ChatTypeDecoration narration();

    public static final class Builder {
        private ChatTypeDecoration chat;
        private ChatTypeDecoration narration;

        private Builder() {
        }

        public Builder chat(ChatTypeDecoration chat) {
            this.chat = chat;
            return this;
        }

        public Builder narration(ChatTypeDecoration narration) {
            this.narration = narration;
            return this;
        }

        public ChatType build() {
            return new ChatTypeImpl(this.chat, this.narration);
        }
    }
}

