/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.monitoring;

import java.util.UUID;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class EventsJFR {
    public static final boolean JFR_AVAILABLE = EventsJFR.jfrAvailable();
    public static final String SERVER_PING = "minestom.ServerPing";
    public static final String SERVER_TICK = "minestom.ServerTickTime";
    public static final String CHUNK_GENERATION = "minestom.ChunkGeneration";
    public static final String CHUNK_LOADING = "minestom.ChunkLoading";
    public static final String INSTANCE_JOIN = "minestom.InstanceJoin";
    public static final String INSTANCE_LEAVE = "minestom.InstanceLeave";
    public static final String PLAYER_JOIN = "minestom.PlayerJoin";
    public static final String PLAYER_LEAVE = "minestom.PlayerLeave";
    public static final String PLAYER_COMMAND = "minestom.PlayerCommand";
    public static final String PLAYER_CHAT = "minestom.PlayerChat";
    private static final EventMarker NO_OP = new NoOpEvent();

    private static boolean jfrAvailable() {
        try {
            Class<?> vmClass = Class.forName("org.graalvm.nativeimage.VMRuntime");
            return false;
        }
        catch (ClassNotFoundException vmClass) {
            try {
                Class.forName("jdk.jfr.Event");
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    public static EventMarker newServerPing(String remoteAddress) {
        return JFR_AVAILABLE ? new ServerPing(remoteAddress) : NO_OP;
    }

    public static EventMarker newServerTick() {
        return JFR_AVAILABLE ? new ServerTick() : NO_OP;
    }

    public static EventMarker newChunkGeneration(UUID instance, int chunkX, int chunkZ) {
        return JFR_AVAILABLE ? new ChunkGeneration(instance.toString(), chunkX, chunkZ) : NO_OP;
    }

    public static EventMarker newChunkLoading(UUID instance, Class loader, int chunkX, int chunkZ) {
        return JFR_AVAILABLE ? new ChunkLoading(instance.toString(), loader, chunkX, chunkZ) : NO_OP;
    }

    public static EventMarker newInstanceJoin(UUID entity, UUID instance) {
        return JFR_AVAILABLE ? new InstanceJoin(entity.toString(), instance.toString()) : NO_OP;
    }

    public static EventMarker newInstanceLeave(UUID entity, UUID instance) {
        return JFR_AVAILABLE ? new InstanceLeave(entity.toString(), instance.toString()) : NO_OP;
    }

    public static EventMarker newPlayerJoin(UUID player) {
        return JFR_AVAILABLE ? new PlayerJoin(player.toString()) : NO_OP;
    }

    public static EventMarker newPlayerLeave(UUID player) {
        return JFR_AVAILABLE ? new PlayerLeave(player.toString()) : NO_OP;
    }

    public static EventMarker newPlayerCommand(UUID player, String command) {
        return JFR_AVAILABLE ? new PlayerCommand(player.toString(), command) : NO_OP;
    }

    public static EventMarker newPlayerChat(UUID player, String message) {
        return JFR_AVAILABLE ? new PlayerChat(player.toString(), message) : NO_OP;
    }

    @Name(value="minestom.ServerPing")
    @Label(value="Server Ping")
    @Category(value={"Minestom", "Server"})
    @Description(value="A server ping (status query) was received")
    private static final class ServerPing
    extends JFREventWrapper {
        @Label(value="Remote Address")
        String remoteAddress;

        private ServerPing(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }
    }

    public static interface EventMarker {
        default public void begin() {
        }

        default public void end() {
        }

        default public void commit() {
        }
    }

    @Name(value="minestom.ServerTickTime")
    @Label(value="Server Tick")
    @Category(value={"Minestom", "Server"})
    @Description(value="Time spent ticking the server once")
    private static final class ServerTick
    extends JFREventWrapper {
        private ServerTick() {
        }
    }

    @Name(value="minestom.ChunkGeneration")
    @Label(value="Chunk Generation")
    @Category(value={"Minestom", "World"})
    @Description(value="Chunk generation from instances' Generator")
    private static final class ChunkGeneration
    extends JFREventWrapper {
        @Label(value="Instance UUID")
        String instance;
        @Label(value="Chunk X")
        int chunkX;
        @Label(value="Chunk Z")
        int chunkZ;

        private ChunkGeneration(String instance, int chunkX, int chunkZ) {
            this.instance = instance;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }

    @Name(value="minestom.ChunkLoading")
    @Label(value="Chunk Loading")
    @Category(value={"Minestom", "World"})
    @Description(value="Chunk loading from the instances' ChunkLoader")
    private static final class ChunkLoading
    extends JFREventWrapper {
        @Label(value="Instance UUID")
        String instance;
        @Label(value="Loader Class")
        Class loader;
        @Label(value="Chunk X")
        int chunkX;
        @Label(value="Chunk Z")
        int chunkZ;

        private ChunkLoading(String instance, Class loader, int chunkX, int chunkZ) {
            this.instance = instance;
            this.loader = loader;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }

    @Name(value="minestom.InstanceJoin")
    @Label(value="Instance Join")
    @Category(value={"Minestom", "Instance"})
    @Description(value="An Entity has joined an instance")
    private static final class InstanceJoin
    extends JFREventWrapper {
        @Label(value="Entity UUID")
        String entity;
        @Label(value="Instance UUID")
        String instance;

        private InstanceJoin(String entity, String instance) {
            this.entity = entity;
            this.instance = instance;
        }
    }

    @Name(value="minestom.InstanceLeave")
    @Label(value="Instance Leave")
    @Category(value={"Minestom", "Instance"})
    @Description(value="An Entity has left an instance")
    private static final class InstanceLeave
    extends JFREventWrapper {
        @Label(value="Entity UUID")
        String entity;
        @Label(value="Instance UUID")
        String instance;

        private InstanceLeave(String entity, String instance) {
            this.entity = entity;
            this.instance = instance;
        }
    }

    @Name(value="minestom.PlayerJoin")
    @Label(value="Player Join")
    @Category(value={"Minestom", "Player"})
    @Description(value="A player joined the server")
    private static final class PlayerJoin
    extends JFREventWrapper {
        @Label(value="Player UUID")
        String player;

        private PlayerJoin(String player) {
            this.player = player;
        }
    }

    @Name(value="minestom.PlayerLeave")
    @Label(value="Player Leave")
    @Category(value={"Minestom", "Player"})
    @Description(value="A player left the server")
    private static final class PlayerLeave
    extends JFREventWrapper {
        @Label(value="Player UUID")
        String player;

        private PlayerLeave(String player) {
            this.player = player;
        }
    }

    @Name(value="minestom.PlayerCommand")
    @Label(value="Player Command")
    @Category(value={"Minestom", "Player"})
    @Description(value="A player executed a command")
    private static final class PlayerCommand
    extends JFREventWrapper {
        @Label(value="Player UUID")
        String player;
        @Label(value="Command")
        String command;

        private PlayerCommand(String player, String command) {
            this.player = player;
            this.command = command;
        }
    }

    @Name(value="minestom.PlayerChat")
    @Label(value="Player Chat")
    @Category(value={"Minestom", "Player"})
    @Description(value="A player sent a chat message")
    private static final class PlayerChat
    extends JFREventWrapper {
        @Label(value="Player UUID")
        String player;
        @Label(value="Message")
        String message;

        private PlayerChat(String player, String message) {
            this.player = player;
            this.message = message;
        }
    }

    private static class NoOpEvent
    implements EventMarker {
        private NoOpEvent() {
        }

        @Override
        public void commit() {
        }
    }

    private static class JFREventWrapper
    extends Event
    implements EventMarker {
        private JFREventWrapper() {
        }
    }
}

