/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.play.ClientConfigurationAckPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.configuration.FinishConfigurationPacket;
import net.minestom.server.network.packet.server.login.LoginSuccessPacket;
import net.minestom.server.network.packet.server.play.StartConfigurationPacket;
import net.minestom.server.utils.ObjectPool;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PacketVanilla {
    public static final PacketParser<ClientPacket> CLIENT_PACKET_PARSER = new PacketParser.Client();
    public static final PacketParser<ServerPacket> SERVER_PACKET_PARSER = new PacketParser.Server();
    public static final ObjectPool<NetworkBuffer> PACKET_POOL = ObjectPool.pool(() -> NetworkBuffer.staticBuffer(ServerFlag.POOLED_BUFFER_SIZE, MinecraftServer.process()), NetworkBuffer::clear);

    public static ConnectionState nextClientState(ClientPacket packet, ConnectionState currentState) {
        ClientPacket clientPacket = packet;
        Objects.requireNonNull(clientPacket);
        ClientPacket clientPacket2 = clientPacket;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientHandshakePacket.class, ClientLoginAcknowledgedPacket.class, ClientConfigurationAckPacket.class, ClientFinishConfigurationPacket.class}, (ClientPacket)clientPacket2, n)) {
            case 0 -> {
                ClientHandshakePacket handshakePacket = (ClientHandshakePacket)clientPacket2;
                switch (handshakePacket.intent()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case STATUS: {
                        yield ConnectionState.STATUS;
                    }
                    case LOGIN: 
                    case TRANSFER: 
                }
                yield ConnectionState.LOGIN;
            }
            case 1 -> {
                ClientLoginAcknowledgedPacket ignored = (ClientLoginAcknowledgedPacket)clientPacket2;
                yield ConnectionState.CONFIGURATION;
            }
            case 2 -> {
                ClientConfigurationAckPacket ignored = (ClientConfigurationAckPacket)clientPacket2;
                yield ConnectionState.CONFIGURATION;
            }
            case 3 -> {
                ClientFinishConfigurationPacket ignored = (ClientFinishConfigurationPacket)clientPacket2;
                yield ConnectionState.PLAY;
            }
            default -> currentState;
        };
    }

    public static ConnectionState nextServerState(ServerPacket packet, ConnectionState currentState) {
        if (currentState == ConnectionState.HANDSHAKE) {
            throw new IllegalStateException("No server Handshake packet exists");
        }
        ServerPacket serverPacket = packet;
        Objects.requireNonNull(serverPacket);
        ServerPacket serverPacket2 = serverPacket;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LoginSuccessPacket.class, StartConfigurationPacket.class, FinishConfigurationPacket.class}, (ServerPacket)serverPacket2, n)) {
            case 0 -> {
                LoginSuccessPacket ignored = (LoginSuccessPacket)serverPacket2;
                yield ConnectionState.CONFIGURATION;
            }
            case 1 -> {
                StartConfigurationPacket ignored = (StartConfigurationPacket)serverPacket2;
                yield ConnectionState.CONFIGURATION;
            }
            case 2 -> {
                FinishConfigurationPacket ignored = (FinishConfigurationPacket)serverPacket2;
                yield ConnectionState.PLAY;
            }
            default -> currentState;
        };
    }
}

