/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet;

import java.util.Queue;
import java.util.function.BiPredicate;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketRegistry;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PacketWriting {
    public static void writeFramedPacket(NetworkBuffer buffer, ConnectionState state, ClientPacket packet, int compressionThreshold) throws IndexOutOfBoundsException {
        PacketWriting.writeFramedPacket(buffer, PacketVanilla.CLIENT_PACKET_PARSER, state, packet, compressionThreshold);
    }

    public static void writeFramedPacket(NetworkBuffer buffer, ConnectionState state, ServerPacket packet, int compressionThreshold) throws IndexOutOfBoundsException {
        PacketWriting.writeFramedPacket(buffer, PacketVanilla.SERVER_PACKET_PARSER, state, packet, compressionThreshold);
    }

    public static <T> void writeFramedPacket(NetworkBuffer buffer, PacketParser<T> parser, ConnectionState state, T packet, int compressionThreshold) throws IndexOutOfBoundsException {
        PacketRegistry<T> registry = parser.stateRegistry(state);
        PacketWriting.writeFramedPacket(buffer, registry, packet, compressionThreshold);
    }

    public static <T> void writeFramedPacket(NetworkBuffer buffer, PacketRegistry<T> registry, T packet, int compressionThreshold) throws IndexOutOfBoundsException {
        PacketRegistry.PacketInfo<T> packetInfo = registry.packetInfo(packet);
        PacketWriting.writeFramedPacket(buffer, packetInfo, packet, compressionThreshold);
    }

    public static <T> void writeFramedPacket(NetworkBuffer buffer, PacketRegistry.PacketInfo<T> packetInfo, T packet, int compressionThreshold) throws IndexOutOfBoundsException {
        int id = packetInfo.id();
        NetworkBuffer.Type<T> serializer = packetInfo.serializer();
        PacketWriting.writeFramedPacket(buffer, serializer, id, packet, compressionThreshold);
    }

    public static <T> void writeFramedPacket(NetworkBuffer buffer, NetworkBuffer.Type<T> type, int id, T packet, int compressionThreshold) throws IndexOutOfBoundsException {
        if (compressionThreshold <= 0) {
            PacketWriting.writeUncompressedFormat(buffer, type, id, packet);
        } else {
            PacketWriting.writeCompressedFormat(buffer, type, id, packet, compressionThreshold);
        }
    }

    private static <T> void writeUncompressedFormat(NetworkBuffer buffer, NetworkBuffer.Type<T> type, int id, T packet) throws IndexOutOfBoundsException {
        long lengthIndex = buffer.advanceWrite(3L);
        buffer.write(NetworkBuffer.VAR_INT, id);
        buffer.write(type, packet);
        long finalSize = buffer.writeIndex() - (lengthIndex + 3L);
        buffer.writeAt(lengthIndex, NetworkBuffer.VAR_INT_3, (int)finalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void writeCompressedFormat(NetworkBuffer buffer, NetworkBuffer.Type<T> type, int id, T packet, int compressionThreshold) throws IndexOutOfBoundsException {
        boolean compressed;
        long compressedIndex = buffer.advanceWrite(3L);
        long uncompressedIndex = buffer.advanceWrite(3L);
        long contentStart = buffer.writeIndex();
        buffer.write(NetworkBuffer.VAR_INT, id);
        buffer.write(type, packet);
        long packetSize = buffer.writeIndex() - contentStart;
        boolean bl = compressed = packetSize >= (long)compressionThreshold;
        if (compressed) {
            NetworkBuffer input = PacketVanilla.PACKET_POOL.get();
            try {
                if (input.capacity() < packetSize) {
                    input.resize(packetSize);
                }
                NetworkBuffer.copy(buffer, contentStart, input, 0L, packetSize);
                buffer.writeIndex(contentStart);
                input.compress(0L, packetSize, buffer);
            }
            finally {
                PacketVanilla.PACKET_POOL.add(input);
            }
        }
        buffer.writeAt(compressedIndex, NetworkBuffer.VAR_INT_3, (int)(buffer.writeIndex() - uncompressedIndex));
        buffer.writeAt(uncompressedIndex, NetworkBuffer.VAR_INT_3, compressed ? (int)packetSize : 0);
    }

    public static NetworkBuffer allocateTrimmedPacket(ConnectionState state, ClientPacket packet, int compressionThreshold) {
        return PacketWriting.allocateTrimmedPacket(PacketVanilla.CLIENT_PACKET_PARSER, state, packet, compressionThreshold);
    }

    public static NetworkBuffer allocateTrimmedPacket(ConnectionState state, ServerPacket packet, int compressionThreshold) {
        return PacketWriting.allocateTrimmedPacket(PacketVanilla.SERVER_PACKET_PARSER, state, packet, compressionThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> NetworkBuffer allocateTrimmedPacket(PacketParser<T> parser, ConnectionState state, T packet, int compressionThreshold) {
        NetworkBuffer buffer = PacketVanilla.PACKET_POOL.get();
        try {
            NetworkBuffer networkBuffer = PacketWriting.allocateTrimmedPacket(buffer, parser, state, packet, compressionThreshold);
            return networkBuffer;
        }
        finally {
            PacketVanilla.PACKET_POOL.add(buffer);
        }
    }

    public static <T> NetworkBuffer allocateTrimmedPacket(NetworkBuffer tmpBuffer, PacketParser<T> parser, ConnectionState state, T packet, int compressionThreshold) {
        PacketRegistry<T> registry = parser.stateRegistry(state);
        return PacketWriting.allocateTrimmedPacket(tmpBuffer, registry, packet, compressionThreshold);
    }

    public static <T> NetworkBuffer allocateTrimmedPacket(NetworkBuffer tmpBuffer, PacketRegistry<T> registry, T packet, int compressionThreshold) {
        PacketRegistry.PacketInfo<T> packetInfo = registry.packetInfo(packet);
        int id = packetInfo.id();
        NetworkBuffer.Type<T> serializer = packetInfo.serializer();
        try {
            PacketWriting.writeFramedPacket(tmpBuffer, serializer, id, packet, compressionThreshold);
            return tmpBuffer.copy(0L, tmpBuffer.writeIndex());
        }
        catch (IndexOutOfBoundsException e) {
            long sizeOf = serializer.sizeOf(packet, tmpBuffer.registries());
            if (sizeOf > (long)ServerFlag.MAX_PACKET_SIZE) {
                throw new IllegalStateException("Packet too large: " + sizeOf);
            }
            tmpBuffer.resize(sizeOf + 15L);
            tmpBuffer.writeIndex(0L);
            PacketWriting.writeFramedPacket(tmpBuffer, serializer, id, packet, compressionThreshold);
            return tmpBuffer.copy(0L, tmpBuffer.writeIndex());
        }
    }

    public static <T> void writeQueue(NetworkBuffer buffer, Queue<T> queue, int minWrite, BiPredicate<NetworkBuffer, T> writer) {
        T packet;
        int size = queue.size();
        minWrite = Math.min(minWrite, size);
        int written = 0;
        while ((packet = queue.peek()) != null) {
            long newSize;
            boolean success;
            long index = buffer.writeIndex();
            try {
                success = writer.test(buffer, (NetworkBuffer)packet);
            }
            catch (IndexOutOfBoundsException e) {
                success = false;
            }
            assert (!success || buffer.writeIndex() > 0L);
            if (success) {
                queue.poll();
                ++written;
                continue;
            }
            buffer.writeIndex(index);
            if (written >= minWrite || (newSize = Math.min(buffer.capacity() * 2L, (long)ServerFlag.MAX_PACKET_SIZE)) == buffer.capacity()) break;
            buffer.resize(newSize);
        }
    }
}

