/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;

public record ClientUpdateSignPacket(Point blockPosition, boolean isFrontText, List<String> lines) implements ClientPacket
{
    public static final NetworkBuffer.Type<ClientUpdateSignPacket> SERIALIZER = new NetworkBuffer.Type<ClientUpdateSignPacket>(){

        @Override
        public void write(NetworkBuffer buffer, ClientUpdateSignPacket value) {
            buffer.write(NetworkBuffer.BLOCK_POSITION, value.blockPosition);
            buffer.write(NetworkBuffer.BOOLEAN, value.isFrontText);
            buffer.write(NetworkBuffer.STRING, value.lines.get(0));
            buffer.write(NetworkBuffer.STRING, value.lines.get(1));
            buffer.write(NetworkBuffer.STRING, value.lines.get(2));
            buffer.write(NetworkBuffer.STRING, value.lines.get(3));
        }

        @Override
        public ClientUpdateSignPacket read(NetworkBuffer buffer) {
            return new ClientUpdateSignPacket(buffer.read(NetworkBuffer.BLOCK_POSITION), buffer.read(NetworkBuffer.BOOLEAN), ClientUpdateSignPacket.readLines(buffer));
        }
    };

    public ClientUpdateSignPacket {
        lines = List.copyOf(lines);
        if (lines.size() != 4) {
            throw new IllegalArgumentException("Signs must have 4 lines!");
        }
        for (String line : lines) {
            if (line.length() <= 384) continue;
            throw new IllegalArgumentException("Signs must have a maximum of 384 characters per line!");
        }
    }

    private static List<String> readLines(NetworkBuffer reader) {
        return List.of(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING));
    }
}

