/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketWriting;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedPacket
implements SendablePacket {
    private final Supplier<ServerPacket> packetSupplier;
    private volatile SoftReference<FramedPacket> packet;

    public CachedPacket(Supplier<ServerPacket> packetSupplier) {
        this.packetSupplier = packetSupplier;
    }

    public CachedPacket(ServerPacket packet) {
        this(() -> packet);
    }

    public void invalidate() {
        this.packet = null;
    }

    public ServerPacket packet(ConnectionState state) {
        FramedPacket cache = this.updatedCache(state);
        return cache != null ? cache.packet() : this.packetSupplier.get();
    }

    @Nullable
    public NetworkBuffer body(ConnectionState state) {
        FramedPacket cache = this.updatedCache(state);
        return cache != null ? cache.body() : null;
    }

    @Nullable
    private FramedPacket updatedCache(ConnectionState state) {
        FramedPacket cache;
        if (!ServerFlag.CACHED_PACKET) {
            return null;
        }
        SoftReference<FramedPacket> ref = this.packet;
        if (ref == null || (cache = ref.get()) == null) {
            ServerPacket packet = this.packetSupplier.get();
            NetworkBuffer buffer = PacketWriting.allocateTrimmedPacket(state, packet, MinecraftServer.getCompressionThreshold());
            cache = new FramedPacket(packet, buffer);
            this.packet = new SoftReference<FramedPacket>(cache);
        }
        return cache;
    }

    public boolean isValid() {
        SoftReference<FramedPacket> ref = this.packet;
        return ref != null && ref.get() != null;
    }

    public String toString() {
        SoftReference<FramedPacket> ref = this.packet;
        FramedPacket cache = ref != null ? ref.get() : null;
        return String.format("CachedPacket{cache=%s}", cache);
    }
}

