/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.configuration;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.validate.Check;

public record SelectKnownPacksPacket(List<Entry> entries) implements ServerPacket.Configuration
{
    private static final int MAX_ENTRIES = 64;
    public static final Entry MINECRAFT_CORE = new Entry("minecraft", "core", "1.21.10");
    public static final NetworkBuffer.Type<SelectKnownPacksPacket> SERIALIZER = NetworkBufferTemplate.template(Entry.SERIALIZER.list(64), SelectKnownPacksPacket::entries, SelectKnownPacksPacket::new);

    public SelectKnownPacksPacket {
        Check.argCondition(entries.size() > 64, "Too many known packs: {0} > {1}", entries.size(), 64);
        entries = List.copyOf(entries);
    }

    public record Entry(String namespace, String id, String version) {
        public static final NetworkBuffer.Type<Entry> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Entry::namespace, NetworkBuffer.STRING, Entry::id, NetworkBuffer.STRING, Entry::version, Entry::new);
    }
}

