/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;

public record BossBarPacket(UUID uuid, Action action) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<BossBarPacket> SERIALIZER = new NetworkBuffer.Type<BossBarPacket>(){

        @Override
        public void write(NetworkBuffer buffer, BossBarPacket value) {
            buffer.write(NetworkBuffer.UUID, value.uuid);
            buffer.write(NetworkBuffer.VAR_INT, value.action.id());
            NetworkBuffer.Type<? extends Action> serializer = BossBarPacket.actionSerializer(value.action.id());
            buffer.write(serializer, value.action);
        }

        @Override
        public BossBarPacket read(NetworkBuffer buffer) {
            UUID uuid = buffer.read(NetworkBuffer.UUID);
            int id = buffer.read(NetworkBuffer.VAR_INT);
            NetworkBuffer.Type<? extends Action> serializer = BossBarPacket.actionSerializer(id);
            return new BossBarPacket(uuid, serializer.read(buffer));
        }
    };

    @Override
    public Collection<Component> components() {
        Collection<Component> collection;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            collection = holder.components();
        } else {
            collection = List.of();
        }
        return collection;
    }

    private static NetworkBuffer.Type<? extends Action> actionSerializer(int id) {
        return switch (id) {
            case 0 -> AddAction.SERIALIZER;
            case 1 -> RemoveAction.SERIALIZER;
            case 2 -> UpdateHealthAction.SERIALIZER;
            case 3 -> UpdateTitleAction.SERIALIZER;
            case 4 -> UpdateStyleAction.SERIALIZER;
            case 5 -> UpdateFlagsAction.SERIALIZER;
            default -> throw new RuntimeException("Unknown action id");
        };
    }

    @Override
    public ServerPacket copyWithOperator(UnaryOperator<Component> operator) {
        BossBarPacket bossBarPacket;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            bossBarPacket = new BossBarPacket(this.uuid, (Action)holder.copyWithOperator(operator));
        } else {
            bossBarPacket = this;
        }
        return bossBarPacket;
    }

    public static sealed interface Action
    permits AddAction, RemoveAction, UpdateHealthAction, UpdateTitleAction, UpdateStyleAction, UpdateFlagsAction {
        public int id();
    }

    public record AddAction(Component title, float health, BossBar.Color color, BossBar.Overlay overlay, byte flags) implements Action,
    ComponentHolder<AddAction>
    {
        public static final NetworkBuffer.Type<AddAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.COMPONENT, AddAction::title, NetworkBuffer.FLOAT, AddAction::health, NetworkBuffer.Enum(BossBar.Color.class), AddAction::color, NetworkBuffer.Enum(BossBar.Overlay.class), AddAction::overlay, NetworkBuffer.BYTE, AddAction::flags, AddAction::new);

        public AddAction(BossBar bar) {
            this(bar.name(), bar.progress(), bar.color(), bar.overlay(), AdventurePacketConvertor.getBossBarFlagValue(bar.flags()));
        }

        @Override
        public int id() {
            return 0;
        }

        @Override
        public Collection<Component> components() {
            return List.of(this.title);
        }

        @Override
        public AddAction copyWithOperator(UnaryOperator<Component> operator) {
            return new AddAction((Component)operator.apply(this.title), this.health, this.color, this.overlay, this.flags);
        }
    }

    public record RemoveAction() implements Action
    {
        public static final NetworkBuffer.Type<RemoveAction> SERIALIZER = NetworkBufferTemplate.template(new RemoveAction());

        @Override
        public int id() {
            return 1;
        }
    }

    public record UpdateHealthAction(float health) implements Action
    {
        public static final NetworkBuffer.Type<UpdateHealthAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.FLOAT, UpdateHealthAction::health, UpdateHealthAction::new);

        public UpdateHealthAction(BossBar bar) {
            this(bar.progress());
        }

        @Override
        public int id() {
            return 2;
        }
    }

    public record UpdateTitleAction(Component title) implements Action,
    ComponentHolder<UpdateTitleAction>
    {
        public static final NetworkBuffer.Type<UpdateTitleAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.COMPONENT, UpdateTitleAction::title, UpdateTitleAction::new);

        public UpdateTitleAction(BossBar bar) {
            this(bar.name());
        }

        @Override
        public int id() {
            return 3;
        }

        @Override
        public Collection<Component> components() {
            return List.of(this.title);
        }

        @Override
        public UpdateTitleAction copyWithOperator(UnaryOperator<Component> operator) {
            return new UpdateTitleAction((Component)operator.apply(this.title));
        }
    }

    public record UpdateStyleAction(BossBar.Color color, BossBar.Overlay overlay) implements Action
    {
        public static final NetworkBuffer.Type<UpdateStyleAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.Enum(BossBar.Color.class), UpdateStyleAction::color, NetworkBuffer.Enum(BossBar.Overlay.class), UpdateStyleAction::overlay, UpdateStyleAction::new);

        public UpdateStyleAction(BossBar bar) {
            this(bar.color(), bar.overlay());
        }

        @Override
        public int id() {
            return 4;
        }
    }

    public record UpdateFlagsAction(byte flags) implements Action
    {
        public static final NetworkBuffer.Type<UpdateFlagsAction> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BYTE, UpdateFlagsAction::flags, UpdateFlagsAction::new);

        public UpdateFlagsAction(BossBar bar) {
            this(AdventurePacketConvertor.getBossBarFlagValue(bar.flags()));
        }

        @Override
        public int id() {
            return 5;
        }
    }
}

