/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;

public record EntityPositionPacket(int entityId, short deltaX, short deltaY, short deltaZ, boolean onGround) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityPositionPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, EntityPositionPacket::entityId, NetworkBuffer.SHORT, EntityPositionPacket::deltaX, NetworkBuffer.SHORT, EntityPositionPacket::deltaY, NetworkBuffer.SHORT, EntityPositionPacket::deltaZ, NetworkBuffer.BOOLEAN, EntityPositionPacket::onGround, EntityPositionPacket::new);

    public static EntityPositionPacket getPacket(int entityId, Pos newPosition, Pos oldPosition, boolean onGround) {
        short deltaX = (short)((newPosition.x() * 32.0 - oldPosition.x() * 32.0) * 128.0);
        short deltaY = (short)((newPosition.y() * 32.0 - oldPosition.y() * 32.0) * 128.0);
        short deltaZ = (short)((newPosition.z() * 32.0 - oldPosition.z() * 32.0) * 128.0);
        return new EntityPositionPacket(entityId, deltaX, deltaY, deltaZ, onGround);
    }
}

