/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.crypto.ChatSession;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.Nullable;

public record PlayerInfoUpdatePacket(EnumSet<Action> actions, List<Entry> entries) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_ENTRIES = 1024;
    public static final NetworkBuffer.Type<PlayerInfoUpdatePacket> SERIALIZER = new NetworkBuffer.Type<PlayerInfoUpdatePacket>(){

        @Override
        public void write(NetworkBuffer writer, PlayerInfoUpdatePacket value) {
            writer.write(NetworkBuffer.EnumSet(Action.class), value.actions);
            writer.write(Entry.serializer(value.actions).list(1024), value.entries);
        }

        @Override
        public PlayerInfoUpdatePacket read(NetworkBuffer reader) {
            EnumSet<Action> actions = reader.read(NetworkBuffer.EnumSet(Action.class));
            List<Entry> entries = reader.read(Entry.serializer(actions).list(1024));
            return new PlayerInfoUpdatePacket(actions, entries);
        }
    };

    public PlayerInfoUpdatePacket(Action action, Entry entry) {
        this(EnumSet.of(action), List.of(entry));
    }

    public PlayerInfoUpdatePacket {
        actions = EnumSet.copyOf(actions);
        entries = List.copyOf(entries);
    }

    @Override
    public Collection<Component> components() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Entry entry : this.entries) {
            if (entry.displayName() == null) continue;
            components.add(entry.displayName());
        }
        return components;
    }

    @Override
    public ServerPacket copyWithOperator(UnaryOperator<Component> operator) {
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        for (Entry entry : this.entries) {
            Component displayName = entry.displayName();
            if (displayName != null) {
                newEntries.add(new Entry(entry.uuid, entry.username, entry.properties, entry.listed, entry.latency, entry.gameMode, (Component)operator.apply(displayName), entry.chatSession, entry.listOrder, entry.displayHat));
                continue;
            }
            newEntries.add(entry);
        }
        return new PlayerInfoUpdatePacket(this.actions, newEntries);
    }

    public record Entry(UUID uuid, String username, List<Property> properties, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable ChatSession chatSession, int listOrder, boolean displayHat) {
        public Entry(UUID uuid, String username, List<Property> properties, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable ChatSession chatSession, int listOrder, boolean displayHat) {
            properties = List.copyOf(properties);
        }

        public static NetworkBuffer.Type<Entry> serializer(final EnumSet<Action> actions) {
            return new NetworkBuffer.Type<Entry>(){

                @Override
                public void write(NetworkBuffer buffer, Entry value) {
                    buffer.write(NetworkBuffer.UUID, value.uuid);
                    for (Action action : actions) {
                        action.writer.write(buffer, value);
                    }
                }

                @Override
                public Entry read(NetworkBuffer buffer) {
                    UUID uuid = buffer.read(NetworkBuffer.UUID);
                    String username = "";
                    List<Property> properties = List.of();
                    boolean listed = false;
                    int latency = 0;
                    GameMode gameMode = GameMode.SURVIVAL;
                    Component displayName = null;
                    ChatSession chatSession = null;
                    int listOrder = 0;
                    boolean displayHat = true;
                    for (Action action : actions) {
                        switch (action.ordinal()) {
                            case 0: {
                                username = buffer.read(NetworkBuffer.STRING);
                                properties = buffer.read(Property.SERIALIZER.list(1024));
                                break;
                            }
                            case 1: {
                                chatSession = ChatSession.SERIALIZER.optional().read(buffer);
                                break;
                            }
                            case 2: {
                                gameMode = buffer.read(NetworkBuffer.Enum(GameMode.class));
                                break;
                            }
                            case 3: {
                                listed = buffer.read(NetworkBuffer.BOOLEAN);
                                break;
                            }
                            case 4: {
                                latency = buffer.read(NetworkBuffer.VAR_INT);
                                break;
                            }
                            case 5: {
                                displayName = buffer.read(NetworkBuffer.COMPONENT.optional());
                                break;
                            }
                            case 6: {
                                listOrder = buffer.read(NetworkBuffer.VAR_INT);
                                break;
                            }
                            case 7: {
                                displayHat = buffer.read(NetworkBuffer.BOOLEAN);
                            }
                        }
                    }
                    return new Entry(uuid, username, properties, listed, latency, gameMode, displayName, chatSession, listOrder, displayHat);
                }
            };
        }
    }

    public static enum Action {
        ADD_PLAYER((writer, entry) -> {
            writer.write(NetworkBuffer.STRING, entry.username);
            writer.write(Property.SERIALIZER.list(), entry.properties);
        }),
        INITIALIZE_CHAT((writer, entry) -> writer.write(ChatSession.SERIALIZER.optional(), entry.chatSession)),
        UPDATE_GAME_MODE((writer, entry) -> writer.write(NetworkBuffer.VAR_INT, entry.gameMode.ordinal())),
        UPDATE_LISTED((writer, entry) -> writer.write(NetworkBuffer.BOOLEAN, entry.listed)),
        UPDATE_LATENCY((writer, entry) -> writer.write(NetworkBuffer.VAR_INT, entry.latency)),
        UPDATE_DISPLAY_NAME((writer, entry) -> writer.write(NetworkBuffer.COMPONENT.optional(), entry.displayName)),
        UPDATE_LIST_ORDER((writer, entry) -> writer.write(NetworkBuffer.VAR_INT, entry.listOrder)),
        UPDATE_HAT((writer, entry) -> writer.write(NetworkBuffer.BOOLEAN, entry.displayHat));

        final Writer writer;

        private Action(Writer writer) {
            this.writer = writer;
        }

        static interface Writer {
            public void write(NetworkBuffer var1, Entry var2);
        }
    }

    public record Property(String name, String value, @Nullable String signature) {
        public static final NetworkBuffer.Type<Property> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Property::name, NetworkBuffer.STRING, Property::value, NetworkBuffer.STRING.optional(), Property::signature, Property::new);

        public Property(String name, String value) {
            this(name, value, null);
        }
    }
}

