/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.scoreboard.Sidebar;
import org.jetbrains.annotations.Nullable;

public record ScoreboardObjectivePacket(String objectiveName, byte mode, @Nullable Component objectiveValue, @Nullable Type type, @Nullable Sidebar.NumberFormat numberFormat) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<ScoreboardObjectivePacket> SERIALIZER = new NetworkBuffer.Type<ScoreboardObjectivePacket>(){

        @Override
        public void write(NetworkBuffer buffer, ScoreboardObjectivePacket value) {
            buffer.write(NetworkBuffer.STRING, value.objectiveName);
            buffer.write(NetworkBuffer.BYTE, value.mode);
            if (value.mode == 0 || value.mode == 2) {
                assert (value.objectiveValue != null);
                buffer.write(NetworkBuffer.COMPONENT, value.objectiveValue);
                assert (value.type != null);
                buffer.write(NetworkBuffer.VAR_INT, value.type.ordinal());
                buffer.write(Sidebar.NumberFormat.SERIALIZER.optional(), value.numberFormat);
            }
        }

        @Override
        public ScoreboardObjectivePacket read(NetworkBuffer buffer) {
            String objectiveName = buffer.read(NetworkBuffer.STRING);
            byte mode = buffer.read(NetworkBuffer.BYTE);
            Component objectiveValue = null;
            Type type = null;
            Sidebar.NumberFormat numberFormat = null;
            if (mode == 0 || mode == 2) {
                objectiveValue = buffer.read(NetworkBuffer.COMPONENT);
                type = Type.values()[buffer.read(NetworkBuffer.VAR_INT)];
                numberFormat = buffer.read(Sidebar.NumberFormat.SERIALIZER.optional());
            }
            return new ScoreboardObjectivePacket(objectiveName, mode, objectiveValue, type, numberFormat);
        }
    };

    @Override
    public Collection<Component> components() {
        return this.mode == 0 || this.mode == 2 ? List.of(this.objectiveValue) : List.of();
    }

    @Override
    public ServerPacket copyWithOperator(UnaryOperator<Component> operator) {
        return this.mode == 0 || this.mode == 2 ? new ScoreboardObjectivePacket(this.objectiveName, this.mode, (Component)operator.apply(this.objectiveValue), this.type, this.numberFormat) : this;
    }

    public static enum Type {
        INTEGER,
        HEARTS;

    }
}

